/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback;

import com.google.common.collect.Maps;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.extremefeedback.Lamps;
import org.jenkinsci.plugins.extremefeedback.model.UdpMessageSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class XfRunListener
extends RunListener<AbstractBuild> {
    private static final Map<Result, Color> resultColorMap;
    private static final Logger LOGGER;

    public void onCompleted(AbstractBuild run, TaskListener listener) {
        Lamps plugin = (Lamps)Jenkins.getInstance().getPlugin(Lamps.class);
        Set<String> jobs = plugin.getJobs();
        if (jobs.contains(run.getParent().getName())) {
            Result result = run.getResult();
            Set<String> ipAddresses = plugin.getIpsContainingJob(run.getParent().getName());
            for (String ipAddress : ipAddresses) {
                this.sendNotification(ipAddress, resultColorMap.get(result), Action.SOLID);
            }
        }
    }

    public void onStarted(AbstractBuild run, TaskListener listener) {
        block4: {
            Lamps plugin = (Lamps)Jenkins.getInstance().getPlugin(Lamps.class);
            Set<String> jobs = plugin.getJobs();
            if (!jobs.contains(run.getParent().getName())) break block4;
            Set<String> ipAddresses = plugin.getIpsContainingJob(run.getParent().getName());
            Run previousBuild = run.getPreviousBuild();
            if (previousBuild == null) {
                for (String ipAddress : ipAddresses) {
                    this.sendNotification(ipAddress, Color.GREEN, Action.SOLID);
                }
            } else {
                for (String ipAddress : ipAddresses) {
                    this.sendNotification(ipAddress, resultColorMap.get(previousBuild.getResult()), Action.FLASHING);
                }
            }
        }
    }

    private void sendNotification(String ipAddress, Color color, Action action) {
        JSONObject gitgear = new JSONObject();
        gitgear.put("color", (Object)color);
        gitgear.put("action", (Object)action);
        byte[] data = gitgear.toString(2).getBytes();
        int port = 39418;
        UdpMessageSender.send(ipAddress, port, data);
    }

    static {
        HashMap map = Maps.newHashMap();
        map.put(Result.ABORTED, Color.RED);
        map.put(Result.FAILURE, Color.RED);
        map.put(Result.NOT_BUILT, Color.RED);
        map.put(Result.UNSTABLE, Color.YELLOW);
        map.put(Result.SUCCESS, Color.GREEN);
        resultColorMap = Collections.unmodifiableMap(map);
        LOGGER = Logger.getLogger("jenkins.plugins.extremefeedback");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        SOLID,
        FLASHING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Color {
        GREEN,
        YELLOW,
        RED;

    }
}

