/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.scm.SCM;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.Collection;
import jenkins.model.Jenkins;
import jenkins.plugins.extracolumns.Messages;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;

public class SCMTypeColumn
extends ListViewColumn {
    @DataBoundConstructor
    public SCMTypeColumn() {
    }

    public String getScmType(Job job) {
        Jenkins instance;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            return project.getScm().getDescriptor().getDisplayName();
        }
        String simpleName = job.getClass().getSimpleName();
        if ("WorkflowJob".equals(simpleName) && (instance = Jenkins.getInstance()) != null && instance.getPlugin("workflow-job") != null) {
            WorkflowJob wfj = (WorkflowJob)job;
            Collection scms = wfj.getSCMs();
            if (scms.size() == 0) {
                return "N/A";
            }
            StringBuffer sb = new StringBuffer();
            for (SCM scm : scms) {
                sb.append(scm.getDescriptor().getDisplayName() + "\n");
            }
            return sb.toString();
        }
        return "N/A";
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.SCMTypeColumn_DisplayName();
        }
    }
}

