/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.Job;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildDescriptionColumn
extends ListViewColumn {
    private int columnWidth;
    private boolean forceWidth;

    @DataBoundConstructor
    public BuildDescriptionColumn(int columnWidth, boolean forceWidth) {
        this.columnWidth = columnWidth;
        this.forceWidth = forceWidth;
    }

    public BuildDescriptionColumn() {
        this(80, false);
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public boolean isForceWidth() {
        return this.forceWidth;
    }

    public String getBuildDescription(Job job) {
        if (job == null || job.getLastCompletedBuild() == null || job.getLastCompletedBuild().getDescription() == null) {
            return "";
        }
        return job.getLastCompletedBuild().getDescription();
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.BuildDescriptionColumn_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/extra-columns/help-buildDescription-column.html";
        }
    }
}

