/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.hudson.plugins.extended_choice_parameter;

import com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterDefinition;
import hudson.model.AbstractBuild;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExtendedChoiceParameterValue
extends StringParameterValue {
    private static final long serialVersionUID = 7993744779892775177L;
    private static final Logger LOGGER = Logger.getLogger(ExtendedChoiceParameterValue.class.getName());

    @DataBoundConstructor
    public ExtendedChoiceParameterValue(String name, String value) {
        super(name, value);
    }

    public VariableResolver<String> createVariableResolver(final AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                String result = null;
                if (ExtendedChoiceParameterValue.this.getName().equals(name)) {
                    ExtendedChoiceParameterDefinition extendedChoiceParameterDefinition;
                    ParameterDefinition parameterDefinition;
                    ParametersDefinitionProperty parametersDefinitionProperty;
                    result = ExtendedChoiceParameterValue.this.value;
                    if (build != null && (parametersDefinitionProperty = (ParametersDefinitionProperty)build.getProject().getProperty(ParametersDefinitionProperty.class)) != null && (parameterDefinition = parametersDefinitionProperty.getParameterDefinition(name)) != null && parameterDefinition instanceof ExtendedChoiceParameterDefinition && "PT_JSON".equals((extendedChoiceParameterDefinition = (ExtendedChoiceParameterDefinition)parameterDefinition).getType()) && extendedChoiceParameterDefinition.isSaveJSONParameterToFile()) {
                        File jsonParametersDir = new File(build.getRootDir(), "parameters");
                        if (!jsonParametersDir.mkdirs()) {
                            LOGGER.log(Level.INFO, "mkdirs failed");
                        }
                        try {
                            File jsonParameterFile = new File(jsonParametersDir, ExtendedChoiceParameterValue.this.getName() + ".json");
                            FileUtils.writeStringToFile((File)jsonParameterFile, (String)ExtendedChoiceParameterValue.this.value);
                            result = jsonParameterFile.getAbsolutePath();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
                return result;
            }
        };
    }
}

