/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge;

import hudson.PluginWrapper;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

class StatusImage
implements HttpResponse {
    private final byte[] payload;
    private static final String PLGIN_NAME = "embeddable-build-status";
    private static final Jenkins jInstance = Jenkins.getInstance();
    private static final PluginWrapper plugin = jInstance != null ? StatusImage.jInstance.pluginManager.getPlugin("embeddable-build-status") : null;
    private static final URL baseUrl = plugin != null ? StatusImage.plugin.baseResourceURL : null;
    private final String etag;
    private final String length;
    private String contentType = null;
    private final Map<String, String> colors = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("red", "#e05d44");
            this.put("brightgreen", "#44cc11");
            this.put("green", "#97CA00");
            this.put("yellowgreen", "#a4a61d");
            this.put("yellow", "#dfb317");
            this.put("orange", "#fe7d37");
            this.put("lightgrey", "#9f9f9f");
            this.put("blue", "#007ec6");
        }
    };

    StatusImage() {
        this.etag = '\"' + Jenkins.RESOURCE_PATH + '/' + "empty" + '\"';
        this.length = Integer.toString(0);
        this.payload = new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatusImage(String fileName) throws IOException {
        URL rootUrl = new URL(jInstance != null ? jInstance.getRootUrl() : "");
        this.etag = '\"' + fileName + '\"';
        URL image = new URL(rootUrl, fileName);
        InputStream s = image.openStream();
        try {
            this.payload = IOUtils.toByteArray((InputStream)s);
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
        this.length = Integer.toString(this.payload.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatusImage(String subject, String status, String colorName, String animatedColorName, String style, String link) throws IOException {
        if (subject != null) {
            subject = StringEscapeUtils.escapeHtml((String)subject);
        }
        if (status != null) {
            status = StringEscapeUtils.escapeHtml((String)status);
        }
        if (animatedColorName != null) {
            animatedColorName = StringEscapeUtils.escapeHtml((String)animatedColorName);
        }
        if (colorName != null) {
            colorName = StringEscapeUtils.escapeHtml((String)colorName);
        }
        if (style != null) {
            style = StringEscapeUtils.escapeHtml((String)style);
        }
        if (link != null) {
            link = StringEscapeUtils.escapeHtml((String)link);
        }
        if (baseUrl != null) {
            String color;
            this.etag = Jenkins.RESOURCE_PATH + '/' + subject + status + colorName + animatedColorName + style;
            if (style == null) {
                style = "flat";
            }
            URL image = new URL(baseUrl, "status/" + style + ".svg");
            URL animatedSnippet = null;
            String animatedColor = null;
            if (animatedColorName != null) {
                animatedSnippet = new URL(baseUrl, "status/animatedOverlay.svg.snippet");
                animatedColor = this.colors.get(animatedColorName.toLowerCase());
                if (animatedColor == null) {
                    animatedColor = colorName.matches("-?[0-9a-fA-F]+") ? "#" + animatedColorName : animatedColorName;
                }
            }
            InputStream s = image.openStream();
            double[] widths = new double[]{this.measureText(subject) + 20, this.measureText(status) + 20};
            if (animatedColor != null) {
                widths[1] = widths[1] + 4.0;
            }
            if ((color = this.colors.get(colorName.toLowerCase())) == null) {
                color = colorName.matches("-?[0-9a-fA-F]+") ? "#" + colorName : colorName;
            }
            String fullwidth = String.valueOf(widths[0] + widths[1]);
            String subjectWidth = String.valueOf(widths[0]);
            String statusWidth = String.valueOf(widths[1]);
            String subjectPos = String.valueOf(widths[0] / 2.0 + 1.0);
            String statusPos = String.valueOf(widths[0] + widths[1] / 2.0 - 1.0);
            String animatedOverlay = "";
            String linkCode = "<svg xmlns";
            if (animatedSnippet != null) {
                String reducedStatusWidth = String.valueOf(widths[1] - 4.0);
                InputStream animatedOverlayStream = animatedSnippet.openStream();
                try {
                    animatedOverlay = IOUtils.toString((InputStream)animatedOverlayStream, (String)"utf-8").replace("{{reducedStatusWidth}}", reducedStatusWidth).replace("{{animatedColor}}", animatedColor);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)animatedOverlayStream);
                }
            }
            if (link != null) {
                linkCode = "<svg onclick=\"window.open('" + link + "');\" style=\"cursor: pointer;\" xmlns";
            }
            try {
                this.payload = IOUtils.toString((InputStream)s, (String)"utf-8").replace("{{animatedOverlayColor}}", animatedOverlay).replace("{{fullwidth}}", fullwidth).replace("{{subjectWidth}}", subjectWidth).replace("{{statusWidth}}", statusWidth).replace("{{subjectPos}}", subjectPos).replace("{{statusPos}}", statusPos).replace("{{subject}}", subject).replace("{{status}}", status).replace("{{color}}", color).replace("<svg xmlns", linkCode).getBytes(Charset.forName("UTF-8"));
            }
            finally {
                IOUtils.closeQuietly((InputStream)s);
            }
            this.length = Integer.toString(this.payload.length);
            this.contentType = "image/svg+xml;charset=utf-8";
        } else {
            this.etag = '\"' + Jenkins.RESOURCE_PATH + '/' + "empty" + '\"';
            this.length = Integer.toString(0);
            this.payload = new byte[0];
        }
    }

    public int measureText(String text) throws IOException {
        if (baseUrl != null) {
            URL fontURL = new URL(baseUrl, "fonts/verdana.ttf");
            InputStream fontStream = fontURL.openStream();
            Font defaultFont = null;
            try {
                defaultFont = Font.createFont(0, fontStream);
            }
            catch (FontFormatException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)fontStream);
            }
            defaultFont = defaultFont.deriveFont(11.0f);
            Canvas canvas = new Canvas();
            FontMetrics fontMetrics = canvas.getFontMetrics(defaultFont);
            return fontMetrics.stringWidth(text);
        }
        return 0;
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        String v = req.getHeader("If-None-Match");
        if (this.etag.equals(v)) {
            rsp.setStatus(304);
            return;
        }
        rsp.setHeader("ETag", this.etag);
        rsp.setHeader("Expires", "Fri, 01 Jan 1984 00:00:00 GMT");
        rsp.setHeader("Cache-Control", "no-cache, no-store, private");
        if (this.contentType != null) {
            rsp.setHeader("Content-Type", this.contentType);
        }
        rsp.setHeader("Content-Length", this.length);
        rsp.getOutputStream().write(this.payload);
    }
}

