/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge.extensions;

import hudson.Extension;
import hudson.model.Actionable;
import hudson.model.Job;
import hudson.model.Run;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.badge.extensionpoints.ParameterResolverExtensionPoint;

@Extension
public class SpecialValueParameterResolverExtension
implements ParameterResolverExtensionPoint {
    private static Pattern custom = Pattern.compile("(buildId|buildNumber|duration|startTime|displayName)");

    @Override
    public String resolve(Actionable actionable, String parameter) {
        if (parameter != null) {
            if (actionable instanceof Run) {
                Run run = (Run)actionable;
                Matcher matcher = custom.matcher(parameter);
                while (matcher.find()) {
                    String customKey = matcher.group(1);
                    parameter = customKey.equals("buildId") ? matcher.replaceFirst(run.getId()) : (customKey.equals("buildNumber") ? matcher.replaceFirst(Integer.toString(run.getNumber())) : (customKey.equals("duration") ? matcher.replaceFirst(run.getDurationString()) : (customKey.equals("displayName") ? matcher.replaceFirst(run.getDisplayName()) : (customKey.equals("startTime") ? matcher.replaceFirst(run.getTimestampString()) : matcher.replaceFirst(customKey)))));
                    matcher = custom.matcher(parameter);
                }
            } else if (actionable instanceof Job) {
                parameter = this.resolve((Actionable)((Job)actionable).getLastBuild(), parameter);
            }
        }
        return parameter;
    }
}

