/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge.extensions;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.badge.extensionpoints.InternalRunSelectorExtensionPoint;

@Extension
public class BuildParameterRunSelectorExtension
implements InternalRunSelectorExtensionPoint {
    private static Pattern outerSelector = Pattern.compile("(last|first)(Failed|Successful|Unsuccessful|Stable|Unstable|Completed){0,1}(:\\$\\{([^\\{\\}\\s]+)\\}){0,1}");
    private static Pattern paramsPattern = Pattern.compile("params\\.([^=]+)=(.*)");

    private Boolean matchRule(Job job, Run run, String rule) {
        if (rule == null) {
            return true;
        }
        Matcher matcher = paramsPattern.matcher(rule);
        if (matcher.find()) {
            ParameterValue value;
            String paramName = matcher.group(1);
            String paramValue = matcher.group(2);
            ParametersAction params = (ParametersAction)run.getAction(ParametersAction.class);
            if (params != null && (value = params.getParameter(paramName)) != null && value.getValue().toString().equals(paramValue)) {
                return true;
            }
        }
        return false;
    }

    private Run findSpecific(Job job, Run run, String what, String specific) {
        if (run == null) {
            if (what.equals("first")) {
                run = this.findSpecific(job, job.getFirstBuild(), what, specific);
            } else {
                if (specific != null) {
                    if (specific.equals("Failed")) {
                        run = job.getLastFailedBuild();
                    } else if (specific.equals("Successful")) {
                        run = job.getLastSuccessfulBuild();
                    } else if (specific.equals("Unsuccessful")) {
                        run = job.getLastUnsuccessfulBuild();
                    } else if (specific.equals("Stable")) {
                        run = job.getLastStableBuild();
                    } else if (specific.equals("Unstable")) {
                        run = job.getLastUnstableBuild();
                    } else if (specific.equals("Completed")) {
                        run = job.getLastCompletedBuild();
                    }
                }
                if (run == null) {
                    run = job.getLastBuild();
                }
            }
        } else {
            do {
                Result result;
                if ((run = what.equals("first") ? run.getNextBuild() : run.getPreviousBuild()) == null) continue;
                Boolean doBreak = specific == null;
                if (!doBreak.booleanValue() && (result = run.getResult()) != null) {
                    Boolean isCompleted = result.isCompleteBuild();
                    Boolean isSuccessful = result == Result.SUCCESS;
                    Boolean isFailed = result == Result.FAILURE;
                    Boolean isUnstable = result == Result.UNSTABLE;
                    Boolean isUnsuccessful = isSuccessful == false;
                    Boolean isStable = isSuccessful;
                    doBreak = specific.equals("Completed") && isCompleted != false || specific.equals("Successful") && isCompleted != false && isSuccessful != false || specific.equals("Failed") && isCompleted != false && isFailed != false || specific.equals("Unstable") && isCompleted != false && isUnstable != false || specific.equals("Unsuccessful") && isCompleted != false && isUnsuccessful != false || specific.equals("isStable") && isCompleted != false && isStable != false;
                }
                if (doBreak.booleanValue()) break;
            } while (run != null);
        }
        return run;
    }

    @Override
    public Run select(Job job, String runId, Run run) {
        Matcher matcher = outerSelector.matcher(runId);
        while (matcher.find()) {
            String what = matcher.group(1);
            String specific = matcher.group(2);
            String rule = matcher.group(4);
            if (run == null) {
                run = this.findSpecific(job, null, what, specific);
            }
            while (run != null && !this.matchRule(job, run, rule).booleanValue()) {
                run = this.findSpecific(job, run, what, specific);
            }
            runId = matcher.replaceAll("");
            matcher = outerSelector.matcher(runId);
        }
        return run;
    }
}

