/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.emailext.Messages;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.JellyLanguage;
import org.kohsuke.stapler.DataBoundConstructor;

public class JellyTemplateConfig
extends Config {
    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(JellyTemplateConfigProvider.class);
    }

    @DataBoundConstructor
    public JellyTemplateConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
        ScriptApproval.get().configuring(content, JellyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public Object readResolve() {
        ScriptApproval.get().configuring(this.content, JellyLanguage.get(), ApprovalContext.create());
        return this;
    }

    @Extension(optional=true)
    public static final class JellyTemplateConfigProvider
    extends AbstractConfigProviderImpl {
        public JellyTemplateConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return ContentType.DefinedType.XML;
        }

        public String getDisplayName() {
            return Messages.JellyTemplateConfigProvider_DisplayName();
        }

        @NonNull
        public Config newConfig(@NonNull String id) {
            return new JellyTemplateConfig(id, "Jelly Email Template", "", "");
        }

        @Deprecated
        protected String getXmlFileName() {
            return "email-ext-jelly-config-files.xml";
        }
    }
}

