/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.Functions;
import hudson.model.Action;
import hudson.model.Run;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class ScriptContentBuildWrapper {
    private Run<?, ?> build;

    public ScriptContentBuildWrapper(Run<?, ?> build) {
        this.build = build;
    }

    @Whitelisted
    public String getTimestampString() {
        return Functions.rfc822Date((Calendar)this.build.getTimestamp());
    }

    public Action getAction(String className) {
        for (Action a : this.build.getAllActions()) {
            if (!a.getClass().getName().equals(className)) continue;
            return a;
        }
        return null;
    }

    @Whitelisted
    public Action getCoberturaAction() {
        return this.getAction("hudson.plugins.cobertura.CoberturaBuildAction");
    }

    @Whitelisted
    public List<TestResult> getJUnitTestResult() {
        TestResultAction action;
        ArrayList<TestResult> result = new ArrayList<TestResult>();
        List actions = this.build.getActions(AggregatedTestResultAction.class);
        for (Action action2 : actions) {
            List reportList = ((AggregatedTestResultAction)action2).getChildReports();
            for (AggregatedTestResultAction.ChildReport report : reportList) {
                if (!(report.result instanceof TestResult)) continue;
                result.add((TestResult)report.result);
            }
        }
        if (result.isEmpty() && (action = (TestResultAction)this.build.getAction(TestResultAction.class)) != null) {
            result.add(action.getResult());
        }
        return result;
    }
}

