/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.JellyTemplateConfig;
import hudson.plugins.emailext.plugins.content.AbstractEvalContent;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import hudson.plugins.emailext.plugins.content.UserProvidedContentInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.JellyLanguage;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.xml.sax.InputSource;

public class JellyScriptContent
extends AbstractEvalContent {
    public static final String MACRO_NAME = "JELLY_SCRIPT";
    private static final String DEFAULT_HTML_TEMPLATE_NAME = "html";
    private static final String DEFAULT_TEMPLATE_NAME = "html";
    public static final String JELLY_EXTENSION = ".jelly";
    @DataBoundTokenMacro.Parameter
    public String template = "html";

    public JellyScriptContent() {
        super(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String evaluate(@NonNull Run<?, ?> run, FilePath workspace, @NonNull TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = this.getFileInputStream(run, workspace, this.template, JELLY_EXTENSION);
            string = this.renderContent(run, inputStream, listener);
        }
        catch (JellyException e) {
            String string2 = "JellyException: " + e.getMessage();
            IOUtils.closeQuietly((InputStream)inputStream);
            return string2;
        }
        catch (FileNotFoundException e2) {
            String string3 = this.generateMissingFile("Jelly", this.template);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return string3;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }

    @Override
    protected Class<? extends ConfigProvider> getProviderClass() {
        return JellyTemplateConfig.JellyTemplateConfigProvider.class;
    }

    private String renderContent(@NonNull Run<?, ?> build, InputStream inputStream, @NonNull TaskListener listener) throws JellyException, IOException {
        JellyContext context;
        Script script;
        String rawScript = IOUtils.toString((InputStream)inputStream);
        if (inputStream instanceof UserProvidedContentInputStream) {
            Job parent = build.getParent();
            ScriptApproval.get().configuring(rawScript, JellyLanguage.get(), ApprovalContext.create().withItem((Item)parent));
            ScriptApproval.get().using(rawScript, JellyLanguage.get());
        }
        if ((script = (context = this.createContext(new ScriptContentBuildWrapper(build), build, listener)).compileScript(new InputSource(new StringReader(rawScript)))) != null) {
            return this.convert(build, context, script);
        }
        return null;
    }

    private String convert(Run<?, ?> build, JellyContext context, Script script) throws JellyTagException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(16384);
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)output);
        script.run(context, xmlOutput);
        xmlOutput.flush();
        xmlOutput.close();
        output.close();
        return output.toString(this.getCharset(build));
    }

    private JellyContext createContext(Object it, @NonNull Run<?, ?> build, @NonNull TaskListener listener) {
        JellyContext context = new JellyContext();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        context.setVariable("it", it);
        context.setVariable("build", build);
        context.setVariable("project", (Object)build.getParent());
        context.setVariable("logger", (Object)listener.getLogger());
        context.setVariable("rooturl", (Object)descriptor.getHudsonUrl());
        return context;
    }
}

