/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MailAccount
extends AbstractDescribableImpl<MailAccount> {
    private String address;
    private String smtpHost;
    private String smtpPort = "25";
    private String smtpUsername;
    private Secret smtpPassword;
    private boolean useSsl;
    private String advProperties;
    private boolean defaultAccount;

    @Deprecated
    public MailAccount(JSONObject jo) {
        this.address = Util.nullify((String)jo.optString("address", null));
        this.smtpHost = Util.nullify((String)jo.optString("smtpHost", null));
        this.smtpPort = Util.nullify((String)jo.optString("smtpPort", null));
        if (jo.optBoolean("auth", false)) {
            this.smtpUsername = Util.nullify((String)jo.optString("smtpUsername", null));
            String pass = Util.nullify((String)jo.optString("smtpPassword", null));
            if (pass != null) {
                this.smtpPassword = Secret.fromString((String)pass);
            }
        }
        this.useSsl = jo.optBoolean("useSsl", false);
        this.advProperties = Util.nullify((String)jo.optString("advProperties", null));
    }

    @DataBoundConstructor
    public MailAccount() {
    }

    public boolean isValid() {
        return this.isFromAddressValid() && this.isSmtpServerValid() && this.isSmtpAuthValid();
    }

    public boolean isFromAddressValid() {
        return this.isDefaultAccount() || StringUtils.isNotBlank((String)this.address);
    }

    public boolean isSmtpServerValid() {
        return true;
    }

    public boolean isSmtpAuthValid() {
        return StringUtils.isBlank((String)this.smtpUsername) || StringUtils.isNotBlank((String)this.smtpUsername) && this.smtpPassword != null;
    }

    public boolean isDefaultAccount() {
        return this.defaultAccount;
    }

    void setDefaultAccount(boolean defaultAccount) {
        this.defaultAccount = defaultAccount;
    }

    public String getAddress() {
        return this.address;
    }

    @DataBoundSetter
    public void setAddress(String address) {
        this.address = Util.fixEmptyAndTrim((String)address);
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    @DataBoundSetter
    public void setSmtpHost(String smtpHost) {
        this.smtpHost = Util.fixEmptyAndTrim((String)smtpHost);
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    @DataBoundSetter
    public void setSmtpPort(String smtpPort) {
        this.smtpPort = Util.fixEmptyAndTrim((String)smtpPort);
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    @DataBoundSetter
    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = Util.fixEmptyAndTrim((String)smtpUsername);
    }

    public Secret getSmtpPassword() {
        return this.smtpPassword;
    }

    @DataBoundSetter
    public void setSmtpPassword(Secret smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = Secret.fromString((String)smtpPassword);
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    @DataBoundSetter
    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public String getAdvProperties() {
        return this.advProperties;
    }

    @DataBoundSetter
    public void setAdvProperties(String advProperties) {
        this.advProperties = advProperties;
    }

    @Extension
    public static class MailAccountDescriptor
    extends Descriptor<MailAccount> {
        public String getDisplayName() {
            return "";
        }
    }
}

