/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildUserRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public BuildUserRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        Run<?, ?> cur = context.getRun();
        Cause.UserIdCause upc = (Cause.UserIdCause)cur.getCause(Cause.UserIdCause.class);
        if (upc == null) {
            context.getListener().getLogger().print("The build was not caused by a user!");
        }
        BuildUserRecipientProvider.addUserTriggeringTheBuild(cur, to, cc, bcc, env, context, debug);
    }

    private static void addUserTriggeringTheBuild(Run<?, ?> run, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, ExtendedEmailPublisherContext context, RecipientProviderUtilities.IDebug debug) {
        User user = RecipientProviderUtilities.getUserTriggeringTheBuild(run);
        if (user != null) {
            RecipientProviderUtilities.addUsers(Collections.singleton(user), context, env, to, cc, bcc, debug);
        }
    }

    @Extension
    @Symbol(value={"buildUser"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        public String getDisplayName() {
            return Messages.BuildUserRecipientProvider_DisplayName();
        }
    }
}

