/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.emailext.groovy.sandbox.PrintStreamInstanceWhitelist;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.RecipientProvider;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractScriptTrigger
extends EmailTrigger {
    protected SecureGroovyScript secureTriggerScript;
    @Deprecated
    protected transient String triggerScript;

    public AbstractScriptTrigger(List<RecipientProvider> recipientProviders, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType, SecureGroovyScript secureTriggerScript) {
        super(recipientProviders, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.secureTriggerScript = secureTriggerScript;
        StaplerRequest request = Stapler.getCurrentRequest();
        ApprovalContext context = ApprovalContext.create().withCurrentUser();
        if (request != null) {
            context = context.withItem((Item)request.findAncestorObject(Item.class));
        }
        this.secureTriggerScript.configuring(context);
    }

    @Deprecated
    public AbstractScriptTrigger(List<RecipientProvider> recipientProviders, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType, String triggerScript) {
        this(recipientProviders, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType, new SecureGroovyScript(triggerScript, false, null));
    }

    @Deprecated
    public AbstractScriptTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequester, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType, String triggerScript) {
        super(sendToList, sendToDevs, sendToRequester, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.triggerScript = triggerScript;
    }

    @Deprecated
    public String getTriggerScript() {
        return this.secureTriggerScript.getScript();
    }

    public SecureGroovyScript getSecureTriggerScript() {
        return this.secureTriggerScript;
    }

    private boolean hasScript() {
        return this.secureTriggerScript != null && StringUtils.isNotEmpty((String)this.secureTriggerScript.getScript());
    }

    @Override
    public boolean configure(@Nonnull StaplerRequest req, @Nonnull JSONObject formData) {
        super.configure(req, formData);
        if (formData.containsKey((Object)"secureTriggerScript")) {
            this.secureTriggerScript = (SecureGroovyScript)req.bindJSON(SecureGroovyScript.class, formData.getJSONObject("secureTriggerScript"));
            this.secureTriggerScript.configuring(ApprovalContext.create().withCurrentUser().withItem((Item)req.findAncestorObject(Item.class)));
        }
        return true;
    }

    @Override
    public abstract boolean isPreBuild();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        boolean result = false;
        if (this.hasScript()) {
            try {
                Object res = this.evaluate(build, listener);
                if (res != null) {
                    result = (Boolean)res;
                }
            }
            catch (IOException e) {
                e.printStackTrace(listener.fatalError("Failed evaluating script trigger %s%n", new Object[]{e.getMessage()}));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluate(AbstractBuild<?, ?> build, TaskListener listener) throws IOException {
        ClassLoader loader = Jenkins.getActiveInstance().getPluginManager().uberClassLoader;
        JenkinsLocationConfiguration configuration = JenkinsLocationConfiguration.get();
        assert (configuration != null);
        URLClassLoader urlcl = null;
        List cp = this.secureTriggerScript.getClasspath();
        if (!cp.isEmpty()) {
            ArrayList<URL> urlList = new ArrayList<URL>(cp.size());
            for (ClasspathEntry entry : cp) {
                ScriptApproval.get().using(entry);
                urlList.add(entry.getURL());
            }
            urlcl = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), loader);
            loader = urlcl;
        }
        try {
            loader = GroovySandbox.createSecureClassLoader((ClassLoader)loader);
            CompilerConfiguration cc = this.secureTriggerScript.isSandbox() ? GroovySandbox.createSecureCompilerConfiguration() : new CompilerConfiguration();
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
            Binding binding = new Binding();
            binding.setVariable("build", build);
            binding.setVariable("project", (Object)build.getParent());
            binding.setVariable("rooturl", (Object)configuration.getUrl());
            PrintStream logger = listener.getLogger();
            binding.setVariable("out", (Object)logger);
            GroovyShell shell = new GroovyShell(loader, binding, cc);
            if (this.secureTriggerScript.isSandbox()) {
                try {
                    Object object = GroovySandbox.run((GroovyShell)shell, (String)this.secureTriggerScript.getScript(), (Whitelist)new ProxyWhitelist(new Whitelist[]{Whitelist.all(), new PrintStreamInstanceWhitelist(logger)}));
                    return object;
                }
                catch (RejectedAccessException x) {
                    throw ScriptApproval.get().accessRejected(x, ApprovalContext.create());
                }
            }
            Object object = shell.evaluate(ScriptApproval.get().using(this.secureTriggerScript.getScript(), GroovyLanguage.get()));
            return object;
        }
        finally {
            if (urlcl != null) {
                urlcl.close();
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.triggerScript != null && this.secureTriggerScript == null) {
            this.secureTriggerScript = new SecureGroovyScript(this.triggerScript, false, null);
            this.secureTriggerScript.configuring(ApprovalContext.create());
            this.triggerScript = null;
        }
        return this;
    }
}

