/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.groovy.sandbox;

import hudson.plugins.emailext.groovy.sandbox.ObjectInstanceWhitelist;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;

public class StaticProxyInstanceWhitelist
extends ObjectInstanceWhitelist<Object> {
    private Whitelist[] proxies;

    public StaticProxyInstanceWhitelist(Object instance, String ... resources) throws IOException {
        super(instance);
        this.proxies = new Whitelist[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            String resource = resources[i];
            this.proxies[i] = StaticWhitelist.from((URL)((Object)((Object)this)).getClass().getResource(resource));
        }
    }

    public boolean permitsMethod(@Nonnull Method method, @Nonnull Object receiver, @Nonnull Object[] args) {
        if (this.permitsInstance(receiver)) {
            for (Whitelist proxy : this.proxies) {
                if (!proxy.permitsMethod(method, receiver, args)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean permitsFieldGet(@Nonnull Field field, @Nonnull Object receiver) {
        if (this.permitsInstance(receiver)) {
            for (Whitelist proxy : this.proxies) {
                if (!proxy.permitsFieldGet(field, receiver)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean permitsFieldSet(@Nonnull Field field, @Nonnull Object receiver, @CheckForNull Object value) {
        return false;
    }
}

