/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.groovy.sandbox;

import java.lang.ref.WeakReference;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AbstractWhitelist;

public abstract class ObjectInstanceWhitelist<T>
extends AbstractWhitelist {
    private final WeakReference<T> instance;

    protected ObjectInstanceWhitelist(T instance) {
        this.instance = new WeakReference<T>(instance);
    }

    protected synchronized boolean permitsInstance(@CheckForNull Object instance) {
        return this.instance.get() == instance;
    }

    protected boolean isClass(Class<?> declaringClass) {
        Object t = this.instance.get();
        if (t != null) {
            for (Class<?> c = t.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                if (declaringClass == c) {
                    return true;
                }
                if (!this.isInterface(declaringClass, c.getInterfaces())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInterface(Class<?> declaringClass, Class[] interfaces) {
        for (Class interf : interfaces) {
            if (declaringClass == interf) {
                return true;
            }
            if (!this.isInterface(declaringClass, interf.getInterfaces())) continue;
            return true;
        }
        return false;
    }
}

