/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Util;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.recipients.CulpritsRecipientProvider;
import hudson.plugins.emailext.plugins.recipients.DevelopersRecipientProvider;
import hudson.plugins.emailext.plugins.recipients.ListRecipientProvider;
import hudson.plugins.emailext.plugins.recipients.RequesterRecipientProvider;
import java.util.ArrayList;
import java.util.List;

public class EmailType {
    private String recipientList = "";
    private String subject = "";
    private String body = "";
    private List<RecipientProvider> recipientProviders = new ArrayList<RecipientProvider>();
    private String attachmentsPattern = "";
    private boolean attachBuildLog = false;
    private boolean compressBuildLog = false;
    private String replyTo = "";
    private String contentType = "project";
    private transient boolean sendToDevelopers;
    private transient boolean sendToRequester;
    private transient boolean includeCulprits;
    private transient boolean sendToRecipientList;

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean getHasRecipients() {
        return this.recipientProviders != null && !this.recipientProviders.isEmpty() || this.recipientList != null && this.recipientList.trim().length() != 0;
    }

    public String getRecipientList() {
        return this.recipientList != null ? this.recipientList.trim() : this.recipientList;
    }

    public List<RecipientProvider> getRecipientProviders() {
        return this.recipientProviders;
    }

    public void addRecipientProvider(RecipientProvider provider) {
        if (this.recipientProviders == null) {
            this.recipientProviders = new ArrayList<RecipientProvider>();
        }
        this.recipientProviders.add(provider);
    }

    public void addRecipientProviders(List<RecipientProvider> providers) {
        if (this.recipientProviders == null) {
            this.recipientProviders = new ArrayList<RecipientProvider>();
        }
        if (providers != null) {
            this.recipientProviders.addAll(providers);
        }
    }

    public void setRecipientList(String recipientList) {
        this.recipientList = Util.fixEmptyAndTrim((String)recipientList);
    }

    public String getReplyTo() {
        return this.replyTo != null ? this.replyTo.trim() : this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = Util.fixEmptyAndTrim((String)replyTo);
    }

    public String getAttachmentsPattern() {
        return this.attachmentsPattern != null ? this.attachmentsPattern.trim() : this.attachmentsPattern;
    }

    public void setAttachmentsPattern(String attachmentsPattern) {
        this.attachmentsPattern = attachmentsPattern;
    }

    public boolean getAttachBuildLog() {
        return this.attachBuildLog;
    }

    public boolean getCompressBuildLog() {
        return this.compressBuildLog;
    }

    public void setAttachBuildLog(boolean attachBuildLog) {
        this.attachBuildLog = attachBuildLog;
    }

    public void setCompressBuildLog(boolean compressBuildLog) {
        this.compressBuildLog = compressBuildLog;
    }

    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = "project";
        }
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Object readResolve() {
        if (this.recipientList != null) {
            this.recipientList = this.recipientList.replaceAll("\\$\\{?PROJECT_DEFAULT_RECIPIENTS\\}?", "");
        }
        if (this.recipientProviders == null) {
            this.recipientProviders = new ArrayList<RecipientProvider>();
        }
        if (this.sendToDevelopers) {
            this.recipientProviders.add(new DevelopersRecipientProvider());
        }
        if (this.sendToRequester) {
            this.recipientProviders.add(new RequesterRecipientProvider());
        }
        if (this.includeCulprits) {
            this.recipientProviders.add(new CulpritsRecipientProvider());
        }
        if (this.sendToRecipientList) {
            this.recipientProviders.add(new ListRecipientProvider());
        }
        return this;
    }

    @Deprecated
    public boolean getSendToCulprits() {
        for (RecipientProvider p : this.recipientProviders) {
            if (!(p instanceof CulpritsRecipientProvider)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void setSendToCulprits(boolean sendToCulprits) {
        if (sendToCulprits && !this.getSendToCulprits()) {
            this.recipientProviders.add(new CulpritsRecipientProvider());
        } else if (!sendToCulprits && this.getSendToCulprits()) {
            int index;
            for (index = 0; index < this.recipientProviders.size() && !(this.recipientProviders.get(index) instanceof CulpritsRecipientProvider); ++index) {
            }
            if (index >= 0 && index < this.recipientProviders.size()) {
                this.recipientProviders.remove(index);
            }
        }
    }

    @Deprecated
    public boolean getSendToDevelopers() {
        for (RecipientProvider p : this.recipientProviders) {
            if (!(p instanceof DevelopersRecipientProvider)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void setSendToDevelopers(boolean sendToDevelopers) {
        if (sendToDevelopers && !this.getSendToDevelopers()) {
            this.recipientProviders.add(new DevelopersRecipientProvider());
        } else if (!sendToDevelopers && this.getSendToDevelopers()) {
            int index;
            for (index = 0; index < this.recipientProviders.size() && !(this.recipientProviders.get(index) instanceof DevelopersRecipientProvider); ++index) {
            }
            if (index >= 0 && index < this.recipientProviders.size()) {
                this.recipientProviders.remove(index);
            }
        }
    }

    @Deprecated
    public boolean getSendToRequester() {
        for (RecipientProvider p : this.recipientProviders) {
            if (!(p instanceof RequesterRecipientProvider)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void setSendToRequester(boolean sendToRequester) {
        if (sendToRequester && !this.getSendToRequester()) {
            this.recipientProviders.add(new RequesterRecipientProvider());
        } else if (!sendToRequester && this.getSendToRequester()) {
            int index;
            for (index = 0; index < this.recipientProviders.size() && !(this.recipientProviders.get(index) instanceof RequesterRecipientProvider); ++index) {
            }
            if (index >= 0 && index < this.recipientProviders.size()) {
                this.recipientProviders.remove(index);
            }
        }
    }

    @Deprecated
    public boolean getSendToRecipientList() {
        for (RecipientProvider p : this.recipientProviders) {
            if (!(p instanceof ListRecipientProvider)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void setSendToRecipientList(boolean sendToRecipientList) {
        if (sendToRecipientList && !this.getSendToRecipientList()) {
            this.recipientProviders.add(new RequesterRecipientProvider());
        } else if (!sendToRecipientList && this.getSendToRecipientList()) {
            int index;
            for (index = 0; index < this.recipientProviders.size() && !(this.recipientProviders.get(index) instanceof ListRecipientProvider); ++index) {
            }
            if (index >= 0 && index < this.recipientProviders.size()) {
                this.recipientProviders.remove(index);
            }
        }
    }
}

