/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.ZipDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang.StringUtils;

public class AttachmentUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String attachmentsPattern;

    public AttachmentUtils(String attachmentsPattern) {
        this.attachmentsPattern = attachmentsPattern;
    }

    private List<MimeBodyPart> getAttachments(ExtendedEmailPublisherContext context) throws MessagingException, InterruptedException, IOException {
        ArrayList<MimeBodyPart> attachments = null;
        FilePath ws = context.getWorkspace();
        long totalAttachmentSize = 0L;
        long maxAttachmentSize = context.getPublisher().getDescriptor().getMaxAttachmentSize();
        if (!StringUtils.isBlank((String)this.attachmentsPattern)) {
            if (ws == null) {
                context.getListener().error("Error: No workspace found!");
            } else {
                FilePath[] files;
                attachments = new ArrayList<MimeBodyPart>();
                for (FilePath file : files = ws.list(ContentBuilder.transformText(this.attachmentsPattern, context, null))) {
                    if (maxAttachmentSize > 0L && totalAttachmentSize + file.length() >= maxAttachmentSize) {
                        context.getListener().getLogger().println("Skipping `" + file.getName() + "' (" + file.length() + " bytes) - too large for maximum attachments size");
                        continue;
                    }
                    MimeBodyPart attachmentPart = new MimeBodyPart();
                    FilePathDataSource fileDataSource = new FilePathDataSource(file);
                    try {
                        attachmentPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                        attachmentPart.setFileName(MimeUtility.encodeText((String)file.getName()));
                        attachmentPart.setContentID(String.format("<%s>", file.getName()));
                        attachments.add(attachmentPart);
                        totalAttachmentSize += file.length();
                    }
                    catch (MessagingException e) {
                        context.getListener().getLogger().println("Error adding `" + file.getName() + "' as attachment - " + e.getMessage());
                    }
                }
            }
        }
        return attachments;
    }

    @Deprecated
    public void attach(Multipart multipart, ExtendedEmailPublisher publisher, AbstractBuild<?, ?> build, BuildListener listener) {
        ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(publisher, build, null, listener);
        this.attach(multipart, context);
    }

    public void attach(Multipart multipart, ExtendedEmailPublisher publisher, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(publisher, build, launcher, listener);
        this.attach(multipart, context);
    }

    public void attach(Multipart multipart, ExtendedEmailPublisherContext context) {
        try {
            List<MimeBodyPart> attachments = this.getAttachments(context);
            if (attachments != null) {
                for (MimeBodyPart attachment : attachments) {
                    multipart.addBodyPart((BodyPart)attachment);
                }
            }
        }
        catch (IOException e) {
            context.getListener().error("Error accessing files to attach: " + e.getMessage());
        }
        catch (MessagingException e) {
            context.getListener().error("Error attaching items to message: " + e.getMessage());
        }
        catch (InterruptedException e) {
            context.getListener().error("Interrupted in processing attachments: " + e.getMessage());
        }
    }

    private static void attachSingleLog(ExtendedEmailPublisherContext context, Run<?, ?> run, Multipart multipart, boolean compress) {
        try {
            File logFile = run.getLogFile();
            long maxAttachmentSize = context.getPublisher().getDescriptor().getMaxAttachmentSize();
            if (maxAttachmentSize > 0L && logFile.length() >= maxAttachmentSize) {
                context.getListener().getLogger().println("Skipping build log attachment -  too large for maximum attachments size");
                return;
            }
            MimeBodyPart attachment = new MimeBodyPart();
            if (compress) {
                context.getListener().getLogger().println("Request made to compress build log");
            }
            LogFileDataSource fileSource = new LogFileDataSource(run, compress);
            if (run instanceof MatrixRun) {
                attachment.setFileName("build-" + ((MatrixRun)run).getParent().getCombination().toString('-', '-') + "." + (compress ? "zip" : "log"));
            } else {
                attachment.setFileName("build." + (compress ? "zip" : "log"));
            }
            attachment.setDataHandler(new DataHandler((DataSource)fileSource));
            multipart.addBodyPart((BodyPart)attachment);
        }
        catch (MessagingException e) {
            context.getListener().error("Error attaching build log to message: " + e.getMessage());
        }
    }

    public static void attachBuildLog(ExtendedEmailPublisherContext context, Multipart multipart, boolean compress) {
        if (context.getRun() instanceof MatrixBuild) {
            MatrixBuild build = (MatrixBuild)context.getRun();
            for (MatrixRun run : build.getExactRuns()) {
                AttachmentUtils.attachSingleLog(context, run, multipart, compress);
            }
        } else {
            AttachmentUtils.attachSingleLog(context, context.getRun(), multipart, compress);
        }
    }

    @Deprecated
    public static void attachBuildLog(ExtendedEmailPublisher publisher, Multipart multipart, AbstractBuild<?, ?> build, BuildListener listener, boolean compress) {
        ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(publisher, build, null, listener);
        AttachmentUtils.attachBuildLog(context, multipart, compress);
    }

    public static void attachBuildLog(ExtendedEmailPublisher publisher, Multipart multipart, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, boolean compress) {
        ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(publisher, build, launcher, listener);
        AttachmentUtils.attachBuildLog(context, multipart, compress);
    }

    private static class LogFileDataSource
    implements DataSource {
        private static final String DATA_SOURCE_NAME = "build.log";
        private final Run<?, ?> run;
        private final boolean compress;

        public LogFileDataSource(Run<?, ?> run, boolean compress) {
            this.run = run;
            this.compress = compress;
        }

        public InputStream getInputStream() throws IOException {
            long logFileLength = this.run.getLogText().length();
            long pos = 0L;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            while (pos < logFileLength) {
                pos = this.run.getLogText().writeLogTo(pos, (OutputStream)bao);
            }
            InputStream res = new ByteArrayInputStream(bao.toByteArray());
            if (this.compress) {
                ZipDataSource z = new ZipDataSource(this.getName(), res);
                res = z.getInputStream();
            }
            return res;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Unsupported");
        }

        public String getContentType() {
            return MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(this.run.getLogFile());
        }

        public String getName() {
            return DATA_SOURCE_NAME;
        }
    }

    private static class FilePathDataSource
    implements DataSource {
        private final FilePath file;

        public FilePathDataSource(FilePath file) {
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            InputStream stream = null;
            try {
                stream = this.file.read();
            }
            catch (InterruptedException e) {
                stream = null;
            }
            return stream;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Unsupported");
        }

        public String getContentType() {
            return MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(this.file.getName());
        }

        public String getName() {
            return this.file.getName();
        }
    }
}

