/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public abstract class AbstractEvalContent
extends DataBoundTokenMacro {
    protected static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";
    protected final String macroName;

    public AbstractEvalContent(String macroName) {
        this.macroName = macroName;
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, build.getWorkspace(), listener, macroName);
    }

    public abstract String evaluate(Run<?, ?> var1, FilePath var2, TaskListener var3, String var4) throws MacroEvaluationException, IOException, InterruptedException;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(this.macroName);
    }

    public static File scriptsFolder() {
        return new File(Jenkins.getActiveInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
    }

    protected abstract Class<? extends ConfigProvider> getProviderClass();

    public boolean hasNestedContent() {
        return false;
    }

    protected InputStream getFileInputStream(FilePath workspace, String fileName, String extension) throws FileNotFoundException, IOException, InterruptedException {
        FilePath file;
        InputStream inputStream = null;
        if (fileName.startsWith("managed:")) {
            String managedFileName = fileName.substring(8);
            try {
                inputStream = this.getManagedFile(managedFileName);
            }
            catch (NoClassDefFoundError e) {
                inputStream = null;
            }
            if (inputStream == null) {
                throw new FileNotFoundException(String.format("Managed file '%s' not found", managedFileName));
            }
            return inputStream;
        }
        String fileExt = FilenameUtils.getExtension((String)fileName);
        if ("".equals(fileExt)) {
            fileName = fileName + extension;
        }
        if (workspace != null && (file = workspace.child(fileName)).exists()) {
            inputStream = file.read();
        }
        if (inputStream == null && (inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName)) == null) {
            File templateFile = new File(AbstractEvalContent.scriptsFolder(), fileName);
            if (!templateFile.exists()) {
                fileName = fileName + extension;
                templateFile = new File(AbstractEvalContent.scriptsFolder(), fileName);
            }
            inputStream = new FileInputStream(templateFile);
        }
        return inputStream;
    }

    private InputStream getManagedFile(String fileName) throws UnsupportedEncodingException {
        ByteArrayInputStream stream = null;
        Plugin plugin = Jenkins.getActiveInstance().getPlugin("config-file-provider");
        if (plugin != null) {
            Config config = null;
            ExtensionList providers = ConfigProvider.all();
            ConfigProvider provider = (ConfigProvider)providers.get(this.getProviderClass());
            for (Config c : provider.getAllConfigs()) {
                if (!c.name.equalsIgnoreCase(fileName)) continue;
                config = c;
                break;
            }
            if (config != null) {
                stream = new ByteArrayInputStream(config.content.getBytes("UTF-8"));
            }
        }
        return stream;
    }

    protected String generateMissingFile(String type, String fileName) {
        return type + " file [" + fileName + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    protected String getCharset(Run<?, ?> build) {
        return ExtendedEmailPublisher.descriptor().getCharset();
    }
}

