/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.AttachmentUtils;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.GroovyScriptPath;
import hudson.plugins.emailext.MatrixTriggerMode;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.CssInliner;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.content.EmailExtScript;
import hudson.plugins.emailext.plugins.content.TriggerNameContent;
import hudson.plugins.emailext.watching.EmailExtWatchAction;
import hudson.plugins.emailext.watching.EmailExtWatchJobProperty;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ExtendedEmailPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisher.class.getName());
    private static final String CONTENT_TRANSFER_ENCODING = System.getProperty(ExtendedEmailPublisher.class.getName() + ".Content-Transfer-Encoding");
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String DEFAULT_EMERGENCY_REROUTE_TEXT = "";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList = "";
    public List<EmailTrigger> configuredTriggers = new ArrayList<EmailTrigger>();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    public String attachmentsPattern;
    public String presendScript;
    public String postsendScript;
    public List<GroovyScriptPath> classpath;
    public boolean attachBuildLog;
    public boolean compressBuildLog;
    public String replyTo;
    public boolean saveOutput = false;
    public boolean disabled = false;
    public MatrixTriggerMode matrixTriggerMode;

    public ExtendedEmailPublisher() {
    }

    @Deprecated
    public ExtendedEmailPublisher(String project_recipient_list, String project_content_type, String project_default_subject, String project_default_content, String project_attachments, String project_presend_script, int project_attach_buildlog, String project_replyto, boolean project_save_output, List<EmailTrigger> project_triggers, MatrixTriggerMode matrixTriggerMode) {
        this(project_recipient_list, project_content_type, project_default_subject, project_default_content, project_attachments, project_presend_script, project_attach_buildlog, project_replyto, project_save_output, project_triggers, matrixTriggerMode, false, Collections.emptyList());
    }

    @DataBoundConstructor
    public ExtendedEmailPublisher(String project_recipient_list, String project_content_type, String project_default_subject, String project_default_content, String project_attachments, String project_presend_script, int project_attach_buildlog, String project_replyto, boolean project_save_output, List<EmailTrigger> project_triggers, MatrixTriggerMode matrixTriggerMode, boolean project_disabled, List<GroovyScriptPath> classpath) {
        this.recipientList = project_recipient_list;
        this.contentType = project_content_type;
        this.defaultSubject = project_default_subject;
        this.defaultContent = project_default_content;
        this.attachmentsPattern = project_attachments;
        this.presendScript = project_presend_script;
        this.attachBuildLog = project_attach_buildlog > 0;
        this.compressBuildLog = project_attach_buildlog > 1;
        this.replyTo = project_replyto;
        this.saveOutput = project_save_output;
        this.configuredTriggers = project_triggers;
        this.matrixTriggerMode = matrixTriggerMode;
        this.disabled = project_disabled;
        this.classpath = classpath;
    }

    @DataBoundSetter
    public void setPostsendScript(String postsendScript) {
        this.postsendScript = postsendScript;
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList<EmailTrigger>();
        }
        return this.configuredTriggers;
    }

    public MatrixTriggerMode getMatrixTriggerMode() {
        return this.matrixTriggerMode == null ? MatrixTriggerMode.BOTH : this.matrixTriggerMode;
    }

    public void setMatrixTriggerMode(MatrixTriggerMode matrixTriggerMode) {
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singletonList(new EmailExtWatchAction(project));
    }

    public void debug(PrintStream p, String format, Object ... args) {
        this.getDescriptor().debug(p, format, args);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.debug(listener.getLogger(), "Checking for pre-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Executing pre-build step", new Object[0]);
            return this._perform(build, null, listener, true);
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.debug(listener.getLogger(), "Checking for post-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Performing post-build step", new Object[0]);
            return this._perform(build, launcher, listener, false);
        }
        return true;
    }

    private boolean _perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, boolean forPreBuild) {
        if (this.disabled) {
            listener.getLogger().println("Extended Email Publisher is currently disabled in project settings");
            return true;
        }
        boolean emailTriggered = false;
        this.debug(listener.getLogger(), "Checking if email needs to be generated", new Object[0]);
        ArrayListMultimap triggered = ArrayListMultimap.create();
        for (EmailTrigger emailTrigger : this.getConfiguredTriggers()) {
            if (emailTrigger.isPreBuild() != forPreBuild || !emailTrigger.trigger(build, (TaskListener)listener)) continue;
            Object tName = emailTrigger.getDescriptor().getDisplayName();
            triggered.put(tName, (Object)emailTrigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList<String> replacedTriggers = new ArrayList<String>();
        for (Object tName : triggered.keySet()) {
            String triggerName = (String)tName;
            for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                replacedTriggers.addAll(trigger.getDescriptor().getTriggerReplaceList());
            }
        }
        for (String triggerName : replacedTriggers) {
            triggered.removeAll((Object)triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        EmailExtWatchJobProperty emailExtWatchJobProperty = (EmailExtWatchJobProperty)((AbstractProject)build.getParent()).getProperty(EmailExtWatchJobProperty.class);
        if (emailExtWatchJobProperty != null) {
            for (String u : emailExtWatchJobProperty.getWatchers()) {
                EmailExtWatchAction.UserProperty prop;
                User user = User.get((String)u);
                if (user == null || (prop = (EmailExtWatchAction.UserProperty)user.getProperty(EmailExtWatchAction.UserProperty.class)) == null) continue;
                ArrayListMultimap watcherTriggered = ArrayListMultimap.create();
                for (EmailTrigger trigger : prop.getTriggers()) {
                    if (trigger.isPreBuild() != forPreBuild || !trigger.trigger(build, (TaskListener)listener)) continue;
                    String tName = trigger.getDescriptor().getDisplayName();
                    watcherTriggered.put((Object)tName, (Object)trigger);
                    listener.getLogger().println("Email was triggered for watcher '" + user.getDisplayName() + "' for: " + tName);
                    emailTriggered = true;
                }
                replacedTriggers = new ArrayList();
                for (EmailTrigger tName : triggered.keySet()) {
                    String triggerName = (String)((Object)tName);
                    for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                        replacedTriggers.addAll(trigger.getDescriptor().getTriggerReplaceList());
                    }
                }
                for (String triggerName : replacedTriggers) {
                    watcherTriggered.removeAll((Object)triggerName);
                    listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
                }
                triggered.putAll((Multimap)watcherTriggered);
            }
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        for (String triggerName : triggered.keySet()) {
            for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                listener.getLogger().println("Sending email for trigger: " + triggerName);
                ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(this, (Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
                context.setTriggered((Multimap<String, EmailTrigger>)triggered);
                context.setTrigger(trigger);
                this.sendMail(context);
            }
        }
        return true;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    boolean sendMail(ExtendedEmailPublisherContext context) {
        try {
            MimeMessage msg = this.createMail(context);
            this.debug(context.getListener().getLogger(), "Successfully created MimeMessage", new Object[0]);
            Address[] allRecipients = msg.getAllRecipients();
            int retries = 0;
            if (allRecipients != null) {
                if (this.executePresendScript(context, msg)) {
                    Transport transport;
                    Session session;
                    block20: {
                        allRecipients = msg.getAllRecipients();
                        if (StringUtils.isNotBlank((String)this.getDescriptor().getEmergencyReroute())) {
                            msg.setRecipients(Message.RecipientType.TO, (Address[])null);
                            msg.setRecipients(Message.RecipientType.CC, (Address[])null);
                            msg.setRecipients(Message.RecipientType.BCC, (Address[])null);
                            msg.setRecipients(Message.RecipientType.TO, this.getDescriptor().getEmergencyReroute());
                        }
                        StringBuilder buf = new StringBuilder("Sending email to:");
                        for (Address a : allRecipients) {
                            buf.append(' ').append(a);
                        }
                        context.getListener().getLogger().println(buf);
                        ExtendedEmailPublisherDescriptor descriptor = this.getDescriptor();
                        session = descriptor.createSession();
                        allRecipients = msg.getAllRecipients();
                        transport = session.getTransport(allRecipients[0]);
                        do {
                            try {
                                transport.connect();
                                transport.sendMessage((Message)msg, allRecipients);
                            }
                            catch (SendFailedException e) {
                                if (e.getNextException() != null && (e.getNextException() instanceof SocketException || e.getNextException() instanceof ConnectException)) {
                                    context.getListener().getLogger().println("Socket error sending email, retrying once more in 10 seconds...");
                                    transport.close();
                                    Thread.sleep(10000L);
                                    continue;
                                }
                                Address[] addresses = e.getValidSentAddresses();
                                if (addresses != null && addresses.length > 0) {
                                    buf = new StringBuilder("Successfully sent to the following addresses:");
                                    for (Address a : addresses) {
                                        buf.append(' ').append(a);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                if ((addresses = e.getValidUnsentAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following VALID addresses:");
                                    for (Address a : addresses) {
                                        buf.append(' ').append(a);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                if ((addresses = e.getInvalidAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following INVALID addresses:");
                                    for (Address a : addresses) {
                                        buf.append(' ').append(a);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                this.debug(context.getListener().getLogger(), "SendFailedException message: " + e.getMessage(), new Object[0]);
                            }
                            catch (MessagingException e) {
                                if (e.getNextException() != null && e.getNextException() instanceof ConnectException) {
                                    context.getListener().getLogger().println("Connection error sending email, retrying once more in 10 seconds...");
                                    transport.close();
                                    Thread.sleep(10000L);
                                    continue;
                                }
                                this.debug(context.getListener().getLogger(), "MessagingException message: " + e.getMessage(), new Object[0]);
                            }
                            break block20;
                        } while (++retries <= 1);
                        context.getListener().getLogger().println("Failed after second try sending email");
                    }
                    this.executePostsendScript(context, msg, session, transport);
                    transport.close();
                    if (context.getRun().getAction(MailMessageIdAction.class) == null) {
                        context.getRun().addAction((Action)new MailMessageIdAction(msg.getMessageID()));
                    }
                } else {
                    context.getListener().getLogger().println("Email sending was cancelled by user script.");
                }
                return true;
            }
            context.getListener().getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(context.getListener().error("Could not send email as a part of the post-build publishers."));
        }
        this.debug(context.getListener().getLogger(), "Some error occured trying to send the email...check the Jenkins log", new Object[0]);
        return false;
    }

    public List<TokenMacro> getRuntimeMacros(ExtendedEmailPublisherContext context) {
        ArrayList<TokenMacro> macros = new ArrayList<TokenMacro>();
        macros.add(new TriggerNameContent(context.getTrigger().getDescriptor().getDisplayName()));
        return macros;
    }

    private boolean executePresendScript(ExtendedEmailPublisherContext context, MimeMessage msg) throws RuntimeException {
        return this.executeScript(this.presendScript, "pre-send", context, msg, null, null);
    }

    private void executePostsendScript(ExtendedEmailPublisherContext context, MimeMessage msg, Session session, Transport transport) throws RuntimeException {
        this.executeScript(this.postsendScript, "post-send", context, msg, session, transport);
    }

    private boolean executeScript(String rawScript, String scriptName, ExtendedEmailPublisherContext context, MimeMessage msg, Session session, Transport transport) {
        boolean cancel = false;
        String script = ContentBuilder.transformText(rawScript, context, this.getRuntimeMacros(context));
        if (StringUtils.isNotBlank((String)script)) {
            this.debug(context.getListener().getLogger(), "Executing %s script", scriptName);
            ClassLoader cl = Jenkins.getActiveInstance().getPluginManager().uberClassLoader;
            CompilerConfiguration cc = new CompilerConfiguration();
            cc.setScriptBaseClass(EmailExtScript.class.getCanonicalName());
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
            this.expandClasspath(context, cc);
            Binding binding = new Binding();
            binding.setVariable("build", context.getBuild());
            binding.setVariable("run", context.getRun());
            binding.setVariable("msg", (Object)msg);
            if (session != null) {
                binding.setVariable("props", (Object)session.getProperties());
            }
            if (transport != null) {
                binding.setVariable("transport", (Object)transport);
            }
            binding.setVariable("listener", (Object)context.getListener());
            binding.setVariable("logger", (Object)context.getListener().getLogger());
            binding.setVariable("cancel", (Object)cancel);
            binding.setVariable("trigger", (Object)context.getTrigger());
            binding.setVariable("triggered", (Object)ImmutableMultimap.copyOf(context.getTriggered()));
            GroovyShell shell = new GroovyShell(cl, binding, cc);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            try {
                shell.evaluate(script);
                cancel = (Boolean)shell.getVariable("cancel");
                this.debug(context.getListener().getLogger(), "%s script set cancel to %b", StringUtils.capitalize((String)scriptName), cancel);
            }
            catch (SecurityException e) {
                context.getListener().getLogger().println(StringUtils.capitalize((String)scriptName) + " script tried to access secured objects: " + e.getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace(pw);
                context.getListener().getLogger().println(out.toString());
            }
            this.debug(context.getListener().getLogger(), out.toString(), new Object[0]);
        }
        return !cancel;
    }

    private void expandClasspath(ExtendedEmailPublisherContext context, CompilerConfiguration cc) {
        List<GroovyScriptPath> globalClasspath;
        ArrayList<String> classpathList = new ArrayList<String>();
        if (this.classpath != null && !this.classpath.isEmpty()) {
            for (GroovyScriptPath path : this.classpath) {
                classpathList.add(ContentBuilder.transformText(path.getPath(), context, this.getRuntimeMacros(context)));
            }
        }
        if ((globalClasspath = this.getDescriptor().getDefaultClasspath()) != null && !globalClasspath.isEmpty()) {
            for (GroovyScriptPath path : globalClasspath) {
                classpathList.add(ContentBuilder.transformText(path.getPath(), context, this.getRuntimeMacros(context)));
            }
        }
        cc.setClasspathList(classpathList);
    }

    private MimeMessage createMail(ExtendedEmailPublisherContext context) throws MessagingException, IOException, InterruptedException {
        String listId;
        MailMessageIdAction b;
        Run<?, ?> pb;
        Result result;
        ExtendedEmailPublisherDescriptor descriptor = this.getDescriptor();
        if (!descriptor.getOverrideGlobalSettings()) {
            descriptor.upgradeFromMailer();
        }
        String charset = descriptor.getCharset();
        Session session = descriptor.createSession();
        MimeMessage msg = new MimeMessage(session);
        InternetAddress from = new InternetAddress(descriptor.getAdminAddress());
        if (from.getPersonal() != null) {
            from.setPersonal(from.getPersonal(), charset);
        }
        msg.setFrom((Address)from);
        if (descriptor.isDebugMode()) {
            session.setDebug(true);
            session.setDebugOut(context.getListener().getLogger());
        }
        msg.addHeader("X-Jenkins-Job", context.getRun().getParent().getDisplayName());
        Result result2 = result = context.getRun() != null ? context.getRun().getResult() : null;
        if (result != null) {
            msg.addHeader("X-Jenkins-Result", result.toString());
        }
        msg.setSentDate(new Date());
        this.setSubject(context, msg, charset);
        Multipart multipart = this.addContent(context, charset);
        AttachmentUtils attachments = new AttachmentUtils(this.attachmentsPattern);
        attachments.attach(multipart, context);
        if (StringUtils.isNotBlank((String)context.getTrigger().getEmail().getAttachmentsPattern())) {
            AttachmentUtils typeAttachments = new AttachmentUtils(context.getTrigger().getEmail().getAttachmentsPattern());
            typeAttachments.attach(multipart, context);
        }
        if (this.attachBuildLog || context.getTrigger().getEmail().getAttachBuildLog()) {
            this.debug(context.getListener().getLogger(), "Request made to attach build log", new Object[0]);
            AttachmentUtils.attachBuildLog(context, multipart, this.compressBuildLog || context.getTrigger().getEmail().getCompressBuildLog());
        }
        msg.setContent(multipart);
        EnvVars env = null;
        try {
            env = context.getRun().getEnvironment(context.getListener());
        }
        catch (Exception e) {
            context.getListener().getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        LinkedHashSet<InternetAddress> to = new LinkedHashSet<InternetAddress>();
        LinkedHashSet<InternetAddress> cc = new LinkedHashSet<InternetAddress>();
        LinkedHashSet<InternetAddress> bcc = new LinkedHashSet<InternetAddress>();
        String emergencyReroute = descriptor.getEmergencyReroute();
        if (StringUtils.isNotBlank((String)emergencyReroute)) {
            this.debug(context.getListener().getLogger(), "Emergency reroute turned on", new Object[0]);
            EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, emergencyReroute, env, context.getListener());
            this.debug(context.getListener().getLogger(), "Emergency reroute is set to: " + emergencyReroute, new Object[0]);
        } else {
            for (RecipientProvider recipientProvider : context.getTrigger().getEmail().getRecipientProviders()) {
                recipientProvider.addRecipients(context, env, to, cc, bcc);
            }
            descriptor.debug(context.getListener().getLogger(), "Adding recipients from trigger recipient list", new Object[0]);
            EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, EmailRecipientUtils.getRecipientList(context, context.getTrigger().getEmail().getRecipientList()), env, context.getListener());
        }
        LinkedHashSet<InternetAddress> excludedRecipients = new LinkedHashSet<InternetAddress>();
        for (InternetAddress recipient : to) {
            if (!EmailRecipientUtils.isExcludedRecipient(recipient.getAddress(), context.getListener())) continue;
            excludedRecipients.add(recipient);
        }
        to.removeAll(excludedRecipients);
        cc.removeAll(excludedRecipients);
        bcc.removeAll(excludedRecipients);
        msg.setRecipients(Message.RecipientType.TO, (Address[])to.toArray(new InternetAddress[to.size()]));
        if (!cc.isEmpty()) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])cc.toArray(new InternetAddress[cc.size()]));
        }
        if (!bcc.isEmpty()) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])bcc.toArray(new InternetAddress[bcc.size()]));
        }
        LinkedHashSet<InternetAddress> linkedHashSet = new LinkedHashSet<InternetAddress>();
        if (StringUtils.isNotBlank((String)this.replyTo)) {
            EmailRecipientUtils.addAddressesFromRecipientList(linkedHashSet, null, null, EmailRecipientUtils.getRecipientList(context, this.replyTo), env, context.getListener());
        }
        if (StringUtils.isNotBlank((String)context.getTrigger().getEmail().getReplyTo())) {
            EmailRecipientUtils.addAddressesFromRecipientList(linkedHashSet, null, null, EmailRecipientUtils.getRecipientList(context, context.getTrigger().getEmail().getReplyTo()), env, context.getListener());
        }
        if (!linkedHashSet.isEmpty()) {
            msg.setReplyTo((Address[])linkedHashSet.toArray(new InternetAddress[linkedHashSet.size()]));
        }
        if ((pb = ExtendedEmailPublisher.getPreviousRun(context.getRun(), context.getListener())) != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null && pb.getResult() != Result.SUCCESS) {
            this.debug(context.getListener().getLogger(), "Setting In-Reply-To since last build was not successful", new Object[0]);
            msg.setHeader("In-Reply-To", b.messageId);
            msg.setHeader("References", b.messageId);
        }
        if (CONTENT_TRANSFER_ENCODING != null) {
            msg.setHeader("Content-Transfer-Encoding", CONTENT_TRANSFER_ENCODING);
        }
        if ((listId = descriptor.getListId()) != null) {
            msg.setHeader("List-ID", listId);
        }
        if (descriptor.getPrecedenceBulk()) {
            msg.setHeader("Precedence", "bulk");
        }
        return msg;
    }

    private void setSubject(ExtendedEmailPublisherContext context, MimeMessage msg, String charset) throws MessagingException {
        String subject = ContentBuilder.transformText(context.getTrigger().getEmail().getSubject(), context, this.getRuntimeMacros(context));
        msg.setSubject(subject, charset);
    }

    public boolean isExecuteOnMatrixNodes() {
        MatrixTriggerMode mtm = this.getMatrixTriggerMode();
        return MatrixTriggerMode.BOTH == mtm || MatrixTriggerMode.ONLY_CONFIGURATIONS == mtm;
    }

    private Multipart addContent(ExtendedEmailPublisherContext context, String charset) throws MessagingException {
        MimeMultipart multipart;
        String messageContentType;
        String text = ContentBuilder.transformText(context.getTrigger().getEmail().getBody(), context, this.getRuntimeMacros(context));
        boolean doBoth = false;
        String string = messageContentType = context.getTrigger().getEmail().getContentType().equals("project") ? this.contentType : context.getTrigger().getEmail().getContentType();
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = this.getDescriptor().getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        if ("both".equals(messageContentType)) {
            doBoth = true;
            multipart = new MimeMultipart("alternative");
            messageContentType = "text/html";
        } else {
            multipart = new MimeMultipart();
        }
        messageContentType = messageContentType + "; charset=" + charset;
        try {
            if (this.saveOutput) {
                String extension = ".html";
                if (messageContentType.startsWith("text/plain")) {
                    extension = ".txt";
                }
                FilePath savedOutput = new FilePath(context.getWorkspace(), String.format("%s-%s%s", context.getTrigger().getDescriptor().getDisplayName(), context.getRun().getId(), extension));
                savedOutput.write(text, charset);
            }
        }
        catch (IOException | InterruptedException e) {
            context.getListener().getLogger().println("Error trying to save email output to file. " + e.getMessage());
        }
        MimeBodyPart msgPart = new MimeBodyPart();
        this.debug(context.getListener().getLogger(), "messageContentType = %s", messageContentType);
        if (messageContentType.startsWith("text/html")) {
            CssInliner inliner = new CssInliner();
            if (doBoth) {
                MimeBodyPart plainTextPart = new MimeBodyPart();
                plainTextPart.setContent((Object)inliner.stripHtml(text), "text/plain; charset=" + charset);
                multipart.addBodyPart((BodyPart)plainTextPart);
            }
            String inlinedCssHtml = inliner.process(text);
            msgPart.setContent((Object)inlinedCssHtml, messageContentType);
        } else {
            msgPart.setContent((Object)text, messageContentType);
        }
        multipart.addBodyPart((BodyPart)msgPart);
        return multipart;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @CheckForNull
    public static Run<?, ?> getPreviousRun(@Nonnull Run<?, ?> run, TaskListener listener) {
        Run previousRun = run.getPreviousBuild();
        if (previousRun != null && previousRun.isBuilding()) {
            listener.getLogger().println(Messages.ExtendedEmailPublisher__is_still_in_progress_ignoring_for_purpo(previousRun.getDisplayName()));
            return null;
        }
        return previousRun;
    }

    public ExtendedEmailPublisherDescriptor getDescriptor() {
        return (ExtendedEmailPublisherDescriptor)Jenkins.getActiveInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public static ExtendedEmailPublisherDescriptor descriptor() {
        return (ExtendedEmailPublisherDescriptor)Jenkins.getActiveInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
    }

    public MatrixAggregator createAggregator(MatrixBuild matrixbuild, Launcher launcher, BuildListener buildlistener) {
        return new MatrixAggregator(matrixbuild, launcher, buildlistener){

            public boolean endBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of {0}", this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.launcher, this.listener, false);
                }
                return true;
            }

            public boolean startBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of {0}", this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.launcher, this.listener, true);
                }
                return true;
            }
        };
    }
}

