/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.scm.ChangeLogSet;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.mail.internet.InternetAddress;

public final class RecipientProviderUtilities {
    private static final Logger LOGGER = Logger.getLogger(RecipientProviderUtilities.class.getName());

    private RecipientProviderUtilities() {
    }

    public static Set<User> getChangeSetAuthors(Collection<Run<?, ?>> runs, IDebug debug) {
        debug.send("  Collecting change authors...", new Object[0]);
        HashSet<User> users = new HashSet<User>();
        for (Run<?, ?> run : runs) {
            debug.send("    build: %d", run.getNumber());
            if (!(run instanceof AbstractBuild)) continue;
            ChangeLogSet changeLogSet = ((AbstractBuild)run).getChangeSet();
            if (changeLogSet == null) {
                debug.send("      changeLogSet was null", new Object[0]);
                continue;
            }
            HashSet<User> changeAuthors = new HashSet<User>();
            for (ChangeLogSet.Entry change : changeLogSet) {
                User changeAuthor = change.getAuthor();
                if (!changeAuthors.add(changeAuthor)) continue;
                debug.send("      adding author: %s", changeAuthor.getFullName());
            }
            users.addAll(changeAuthors);
        }
        return users;
    }

    public static Set<User> getUsersTriggeringTheBuilds(Collection<Run<?, ?>> runs, IDebug debug) {
        debug.send("  Collecting build requestors...", new Object[0]);
        HashSet<User> users = new HashSet<User>();
        for (Run<?, ?> run : runs) {
            debug.send("    build: %d", run.getNumber());
            User buildRequestor = RecipientProviderUtilities.getUserTriggeringTheBuild(run);
            if (buildRequestor != null) {
                debug.send("      adding requestor: %s", buildRequestor.getFullName());
                users.add(buildRequestor);
                continue;
            }
            debug.send("      buildRequestor was null", new Object[0]);
        }
        return users;
    }

    private static User getByUserIdCause(Run<?, ?> run) {
        try {
            Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
            if (cause != null) {
                String id = cause.getUserId();
                return User.get((String)id, (boolean)false, null);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private static User getByLegacyUserCause(Run<?, ?> run) {
        try {
            Cause.UserCause userCause = (Cause.UserCause)run.getCause(Cause.UserCause.class);
            if (userCause != null) {
                Field authenticationName = Cause.UserCause.class.getDeclaredField("authenticationName");
                authenticationName.setAccessible(true);
                String name = (String)authenticationName.get(userCause);
                return User.get((String)name, (boolean)false, null);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    public static User getUserTriggeringTheBuild(Run<?, ?> run) {
        User user = RecipientProviderUtilities.getByUserIdCause(run);
        if (user == null) {
            user = RecipientProviderUtilities.getByLegacyUserCause(run);
        }
        return user;
    }

    public static void addUsers(Set<User> users, TaskListener listener, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, IDebug debug) {
        for (User user : users) {
            if (EmailRecipientUtils.isExcludedRecipient(user, listener)) {
                debug.send("User %s is an excluded recipient.", user.getFullName());
                continue;
            }
            String userAddress = EmailRecipientUtils.getUserConfiguredEmail(user);
            if (userAddress != null) {
                debug.send("Adding %s with address %s", user.getFullName(), userAddress);
                EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, userAddress, env, listener);
                continue;
            }
            listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
        }
    }

    public static interface IDebug {
        public void send(String var1, Object ... var2);
    }
}

