/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public abstract class AbstractEvalContent
extends DataBoundTokenMacro {
    protected static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";
    protected final String macroName;

    public AbstractEvalContent(String macroName) {
        this.macroName = macroName;
    }

    public abstract String evaluate(AbstractBuild<?, ?> var1, TaskListener var2, String var3) throws MacroEvaluationException, IOException, InterruptedException;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(this.macroName);
    }

    public static File scriptsFolder() {
        return new File(Jenkins.getActiveInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
    }

    protected abstract ConfigProvider getConfigProvider();

    public boolean hasNestedContent() {
        return false;
    }

    protected InputStream getFileInputStream(String fileName, String extension) throws FileNotFoundException {
        InputStream inputStream;
        if (fileName.startsWith("managed:")) {
            InputStream inputStream2;
            String managedFileName = fileName.substring(8);
            try {
                inputStream2 = this.getManagedFile(managedFileName);
            }
            catch (NoClassDefFoundError e) {
                inputStream2 = null;
            }
            if (inputStream2 == null) {
                throw new FileNotFoundException(String.format("Managed file '%s' not found", managedFileName));
            }
            return inputStream2;
        }
        String fileExt = FilenameUtils.getExtension((String)fileName);
        if (fileExt.equals("")) {
            fileName = fileName + extension;
        }
        if ((inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName)) == null) {
            File templateFile = new File(AbstractEvalContent.scriptsFolder(), fileName);
            if (!templateFile.exists()) {
                fileName = fileName + extension;
                templateFile = new File(AbstractEvalContent.scriptsFolder(), fileName);
            }
            inputStream = new FileInputStream(templateFile);
        }
        return inputStream;
    }

    private InputStream getManagedFile(String fileName) {
        ByteArrayInputStream stream = null;
        Plugin plugin = Jenkins.getActiveInstance().getPlugin("config-file-provider");
        if (plugin != null) {
            Config config = null;
            ConfigProvider provider = this.getConfigProvider();
            for (Config c : provider.getAllConfigs()) {
                if (!c.name.equalsIgnoreCase(fileName) || !provider.isResponsibleFor(c.id)) continue;
                config = c;
                break;
            }
            if (config != null) {
                stream = new ByteArrayInputStream(config.content.getBytes());
            }
        }
        return stream;
    }

    protected String generateMissingFile(String type, String fileName) {
        return type + " file [" + fileName + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    protected String getCharset(AbstractBuild<?, ?> build) {
        return ExtendedEmailPublisher.descriptor().getCharset();
    }
}

