/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class EmailRecipientUtils {
    private static final Logger LOGGER = Logger.getLogger(EmailRecipientUtils.class.getName());
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    public static final int TO = 0;
    public static final int CC = 1;
    public static final int BCC = 2;

    public static Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars) throws AddressException, UnsupportedEncodingException {
        return EmailRecipientUtils.convertRecipientString(recipientList, envVars, 0);
    }

    public static Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars, int type) throws AddressException, UnsupportedEncodingException {
        LinkedHashSet<InternetAddress> internetAddresses = new LinkedHashSet<InternetAddress>();
        if (!StringUtils.isBlank((String)recipientList)) {
            String expandedRecipientList = EmailRecipientUtils.fixupSpaces(envVars.expand(recipientList));
            InternetAddress[] all = InternetAddress.parse((String)expandedRecipientList.replace("bcc:", "").replace("cc:", ""));
            LinkedHashSet<InternetAddress> to = new LinkedHashSet<InternetAddress>();
            LinkedHashSet<InternetAddress> cc = new LinkedHashSet<InternetAddress>();
            LinkedHashSet<InternetAddress> bcc = new LinkedHashSet<InternetAddress>();
            String defaultSuffix = ExtendedEmailPublisher.descriptor().getDefaultSuffix();
            for (InternetAddress address : all) {
                if (address.getPersonal() != null) {
                    if (expandedRecipientList.contains("bcc:" + address.getPersonal()) || expandedRecipientList.contains("bcc:\"" + address.toString() + "\"")) {
                        bcc.add(address);
                        continue;
                    }
                    if (expandedRecipientList.contains("cc:" + address.getPersonal()) || expandedRecipientList.contains("cc:\"" + address.toString() + "\"")) {
                        cc.add(address);
                        continue;
                    }
                    to.add(address);
                    continue;
                }
                if (expandedRecipientList.contains("bcc:" + address.toString())) {
                    bcc.add(address);
                    continue;
                }
                if (expandedRecipientList.contains("cc:" + address.toString())) {
                    cc.add(address);
                    continue;
                }
                to.add(address);
            }
            if (type == 2) {
                internetAddresses.addAll(bcc);
            } else if (type == 1) {
                internetAddresses.addAll(cc);
            } else {
                internetAddresses.addAll(to);
            }
            for (InternetAddress address : internetAddresses) {
                String userEmail;
                User u;
                if (!address.getAddress().contains("@") && (u = User.get((String)address.getAddress(), (boolean)false, null)) != null && (userEmail = EmailRecipientUtils.getUserConfiguredEmail(u)) != null) {
                    address.setAddress(userEmail);
                }
                if (!address.getAddress().contains("@") && defaultSuffix != null && defaultSuffix.contains("@")) {
                    address.setAddress(address.getAddress() + defaultSuffix);
                }
                if (address.getPersonal() == null) continue;
                address.setPersonal(address.getPersonal(), ExtendedEmailPublisher.descriptor().getCharset());
            }
        }
        return internetAddresses;
    }

    public static String getUserConfiguredEmail(User user) {
        Mailer.UserProperty mailProperty;
        String addr = null;
        if (user != null && (mailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) != null) {
            addr = mailProperty.getAddress();
            String message = String.format("Resolved %s to %s", user.getId(), addr);
            LOGGER.fine(message);
        }
        return addr;
    }

    public FormValidation validateFormRecipientList(String recipientList) {
        try {
            EmailRecipientUtils.convertRecipientString(recipientList, new EnvVars(), 0);
            EmailRecipientUtils.convertRecipientString(recipientList, new EnvVars(), 2);
            EmailRecipientUtils.convertRecipientString(recipientList, new EnvVars(), 1);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)(e.getMessage() + ": \"" + e.getRef() + "\""));
        }
        catch (UnsupportedEncodingException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    private static String fixupSpaces(String input) {
        if ((input = input.replaceAll("\\s+", " ")).contains(" ") && !input.contains(",")) {
            input = input.replace(" ", ",");
        }
        return input;
    }

    public static boolean isExcludedRecipient(String userName, TaskListener listener) {
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        StringTokenizer tokens = new StringTokenizer(descriptor.getExcludedCommitters(), ",");
        while (tokens.hasMoreTokens()) {
            String check = tokens.nextToken().trim();
            descriptor.debug(listener.getLogger(), "Checking '%s' against '%s' to see if they are excluded", userName, check);
            if (!check.equalsIgnoreCase(userName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExcludedRecipient(User user, TaskListener listener) {
        String[] testValues;
        for (String testValue : testValues = new String[]{user.getFullName(), user.getId(), user.getDisplayName()}) {
            if (testValue == null || !EmailRecipientUtils.isExcludedRecipient(testValue, listener)) continue;
            return true;
        }
        return false;
    }

    public static void addAddressesFromRecipientList(Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, String recipientList, EnvVars envVars, TaskListener listener) {
        try {
            Set<InternetAddress> internetAddresses = EmailRecipientUtils.convertRecipientString(recipientList, envVars, 0);
            to.addAll(internetAddresses);
            if (bcc != null && bcc.size() > 0) {
                Set<InternetAddress> bccInternetAddresses = EmailRecipientUtils.convertRecipientString(recipientList, envVars, 2);
                bcc.addAll(bccInternetAddresses);
            }
            if (cc != null && cc.size() > 0) {
                Set<InternetAddress> ccInternetAddresses = EmailRecipientUtils.convertRecipientString(recipientList, envVars, 1);
                cc.addAll(ccInternetAddresses);
            }
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + ae.getRef());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Could not create email address.", e);
            listener.getLogger().println("Failed to create e-mail address because of invalid encoding");
        }
    }

    public static String getRecipientList(ExtendedEmailPublisherContext context, String recipients) throws MessagingException {
        String recipientsTransformed = StringUtils.isBlank((String)recipients) ? "" : ContentBuilder.transformText(recipients, context, context.getPublisher().getRuntimeMacros(context));
        return recipientsTransformed;
    }
}

