/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class JenkinsURLContent
extends DataBoundTokenMacro {
    private static final String MACRO_NAME = "JENKINS_URL";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME) || macroName.equals("HUDSON_URL");
    }

    public String getHelpText() {
        return "Displays the URL to the Jenkins server. (You can change this on the system configuration page.)";
    }

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String jenkinsUrl = Jenkins.getInstance().getRootUrl();
        ExtendedEmailPublisher publisher = (ExtendedEmailPublisher)context.getProject().getPublishersList().get(ExtendedEmailPublisher.class);
        if (publisher.getDescriptor().getOverrideGlobalSettings()) {
            jenkinsUrl = publisher.getDescriptor().getHudsonUrl();
        }
        if (jenkinsUrl == null) {
            return "";
        }
        if (!jenkinsUrl.endsWith("/")) {
            jenkinsUrl = jenkinsUrl + "/";
        }
        return Util.encode((String)jenkinsUrl);
    }
}

