/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class WorkspaceFileContent
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter(required=true)
    public String path = "";
    @DataBoundTokenMacro.Parameter
    public String fileNotFoundMessage = "ERROR: File '%s' does not exist";
    public static final String MACRO_NAME = "FILE";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        try {
            EnvVars env = context.getEnvironment(listener);
            this.path = env.expand(this.path);
        }
        catch (Exception e) {
            listener.error("Error retrieving environment");
        }
        if (!context.getWorkspace().child(this.path).exists()) {
            return String.format(this.fileNotFoundMessage, this.path);
        }
        try {
            return context.getWorkspace().child(this.path).readToString();
        }
        catch (IOException e) {
            return "ERROR: File '" + this.path + "' could not be read";
        }
    }

    public boolean hasNestedContent() {
        return true;
    }
}

