/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.GroovyTemplateConfig;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.content.EmailExtScript;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public class ScriptContent
extends DataBoundTokenMacro {
    private static final Logger LOGGER = Logger.getLogger(ScriptContent.class.getName());
    @DataBoundTokenMacro.Parameter
    public String script = "";
    private static final String DEFAULT_TEMPLATE_NAME = "groovy-html.template";
    @DataBoundTokenMacro.Parameter
    public String template = "groovy-html.template";
    private static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";
    public static final String MACRO_NAME = "SCRIPT";
    private static Object configProvider;
    private static final Map<String, Reference<Template>> templateCache;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String result;
        InputStream inputStream;
        block7: {
            inputStream = null;
            result = "";
            try {
                if (!StringUtils.isEmpty((String)this.script)) {
                    inputStream = this.getFileInputStream(this.script);
                    result = this.executeScript(context, listener, inputStream);
                    break block7;
                }
                inputStream = this.getFileInputStream(this.template);
                result = this.renderTemplate(context, listener, inputStream);
            }
            catch (FileNotFoundException e) {
                String missingScriptError = this.generateMissingFile(this.script, this.template);
                LOGGER.log(Level.SEVERE, missingScriptError);
                result = missingScriptError;
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (GroovyRuntimeException e2) {
                result = "Error in script or template: " + e2.toString();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    private String generateMissingFile(String script, String template) {
        if (!StringUtils.isEmpty((String)script)) {
            return "Script [" + script + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
        }
        return "Template [" + template + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    private InputStream getFileInputStream(String fileName) throws FileNotFoundException {
        if (fileName.startsWith("managed:")) {
            InputStream inputStream;
            String managedFileName = fileName.substring(8);
            try {
                inputStream = this.getManagedFile(managedFileName);
            }
            catch (NoClassDefFoundError e) {
                inputStream = null;
            }
            if (inputStream == null) {
                throw new FileNotFoundException(String.format("Managed file '%s' not found", managedFileName));
            }
            return inputStream;
        }
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName);
        if (inputStream == null) {
            File scriptsFolder = ScriptContent.scriptsFolder();
            File scriptFile = new File(scriptsFolder, fileName);
            inputStream = new FileInputStream(scriptFile);
        }
        return inputStream;
    }

    static File scriptsFolder() {
        return new File(Jenkins.getInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
    }

    private InputStream getManagedFile(String templateName) {
        Plugin plugin = Jenkins.getInstance().getPlugin("config-file-provider");
        ByteArrayInputStream stream = null;
        if (plugin != null) {
            Config config = null;
            ConfigProvider provider = ScriptContent.getTemplateConfigProvider();
            for (Config c : provider.getAllConfigs()) {
                if (!c.name.equalsIgnoreCase(templateName) || !provider.isResponsibleFor(c.id)) continue;
                config = c;
                break;
            }
            if (config != null) {
                stream = new ByteArrayInputStream(config.content.getBytes());
            }
        }
        return stream;
    }

    private static ConfigProvider getTemplateConfigProvider() {
        if (configProvider == null) {
            ExtensionList providers = ConfigProvider.all();
            configProvider = providers.get(GroovyTemplateConfig.GroovyTemplateConfigProvider.class);
        }
        return (ConfigProvider)configProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderTemplate(AbstractBuild<?, ?> build, TaskListener listener, InputStream templateStream) throws IOException {
        String result;
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        binding.put("build", build);
        binding.put("listener", listener);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("rooturl", descriptor.getHudsonUrl());
        binding.put("project", build.getParent());
        GroovyShell shell = this.createEngine(descriptor, Collections.EMPTY_MAP);
        SimpleTemplateEngine engine = new SimpleTemplateEngine(shell);
        try {
            Template tmpl;
            String text = IOUtils.toString((InputStream)templateStream);
            Map<String, Reference<Template>> map = templateCache;
            synchronized (map) {
                Reference<Template> templateR = templateCache.get(text);
                Template template = tmpl = templateR == null ? null : templateR.get();
                if (tmpl == null) {
                    tmpl = engine.createTemplate(text);
                    templateCache.put(text, new SoftReference<Template>(tmpl));
                }
            }
            result = tmpl.make(binding).toString();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            result = "Exception raised during template rendering: " + e.getMessage() + "\n\n" + sw.toString();
        }
        return result;
    }

    private String executeScript(AbstractBuild<?, ?> build, TaskListener listener, InputStream scriptStream) throws IOException {
        String result = "";
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        binding.put("build", build);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("project", build.getParent());
        binding.put("rooturl", descriptor.getHudsonUrl());
        binding.put("logger", listener.getLogger());
        GroovyShell shell = this.createEngine(descriptor, binding);
        Object res = shell.evaluate((Reader)new InputStreamReader(scriptStream));
        if (res != null) {
            result = res.toString();
        }
        return result;
    }

    private GroovyShell createEngine(ExtendedEmailPublisherDescriptor descriptor, Map<String, Object> variables) throws FileNotFoundException, IOException {
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        ScriptSandbox sandbox = null;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(EmailExtScript.class.getCanonicalName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        if (descriptor.isSecurityEnabled()) {
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
            sandbox = new ScriptSandbox();
        }
        Binding binding = new Binding();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            binding.setVariable(e.getKey(), e.getValue());
        }
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        if (sandbox != null) {
            sandbox.register();
        }
        return shell;
    }

    public boolean hasNestedContent() {
        return false;
    }

    static {
        templateCache = new HashMap<String, Reference<Template>>();
    }
}

