/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.ExtensionList;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.JellyTemplateConfig;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import hudson.tasks.Mailer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.xml.sax.InputSource;

public class JellyScriptContent
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "JELLY_SCRIPT";
    private static final String DEFAULT_HTML_TEMPLATE_NAME = "html";
    private static final String DEFAULT_TEXT_TEMPLATE_NAME = "text";
    private static final String DEFAULT_TEMPLATE_NAME = "html";
    private static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";
    private static Object configProvider;
    @DataBoundTokenMacro.Parameter
    public String template = "html";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = this.getTemplateInputStream(this.template);
            string = this.renderContent(build, inputStream, listener);
        }
        catch (JellyException e) {
            String string2 = "JellyException: " + e.getMessage();
            IOUtils.closeQuietly((InputStream)inputStream);
            return string2;
        }
        catch (FileNotFoundException e2) {
            String missingTemplateError;
            String string3 = missingTemplateError = this.generateMissingTemplate(this.template);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return string3;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }

    private String generateMissingTemplate(String template) {
        return "Jelly script [" + template + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    private InputStream getTemplateInputStream(String templateName) throws FileNotFoundException {
        InputStream inputStream;
        if (templateName.startsWith("managed:")) {
            InputStream inputStream2;
            String managedTemplateName = templateName.substring(8);
            try {
                inputStream2 = this.getManagedTemplate(managedTemplateName);
            }
            catch (NoClassDefFoundError e) {
                inputStream2 = null;
            }
            if (inputStream2 == null) {
                throw new FileNotFoundException(String.format("Managed template '%s' not found", managedTemplateName));
            }
            return inputStream2;
        }
        if (!templateName.endsWith(".jelly")) {
            templateName = templateName + ".jelly";
        }
        if ((inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + templateName)) == null) {
            File templatesFolder = new File(Hudson.getInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
            File templateFile = new File(templatesFolder, templateName);
            inputStream = new FileInputStream(templateFile);
        }
        return inputStream;
    }

    private InputStream getManagedTemplate(String templateName) {
        Plugin plugin = Jenkins.getInstance().getPlugin("config-file-provider");
        ByteArrayInputStream stream = null;
        if (plugin != null) {
            Config config = null;
            ConfigProvider provider = JellyScriptContent.getTemplateConfigProvider();
            for (Config c : provider.getAllConfigs()) {
                if (!c.name.equalsIgnoreCase(templateName) || !provider.isResponsibleFor(c.id)) continue;
                config = c;
                break;
            }
            if (config != null) {
                stream = new ByteArrayInputStream(config.content.getBytes());
            }
        }
        return stream;
    }

    private static ConfigProvider getTemplateConfigProvider() {
        if (configProvider == null) {
            ExtensionList providers = ConfigProvider.all();
            configProvider = providers.get(JellyTemplateConfig.JellyTemplateConfigProvider.class);
        }
        return (ConfigProvider)configProvider;
    }

    private String renderContent(AbstractBuild<?, ?> build, InputStream inputStream, TaskListener listener) throws JellyException, IOException {
        JellyContext context = this.createContext(new ScriptContentBuildWrapper(build), build, listener);
        Script script = context.compileScript(new InputSource(inputStream));
        if (script != null) {
            return this.convert(build, context, script);
        }
        return null;
    }

    private String convert(AbstractBuild<?, ?> build, JellyContext context, Script script) throws JellyTagException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(16384);
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)output);
        script.run(context, xmlOutput);
        xmlOutput.flush();
        xmlOutput.close();
        output.close();
        return output.toString(this.getCharset(build));
    }

    private JellyContext createContext(Object it, AbstractBuild<?, ?> build, TaskListener listener) {
        JellyContext context = new JellyContext();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        context.setVariable("it", it);
        context.setVariable("build", build);
        context.setVariable("project", (Object)build.getParent());
        context.setVariable("logger", (Object)listener.getLogger());
        context.setVariable("rooturl", (Object)descriptor.getHudsonUrl());
        return context;
    }

    private String getCharset(AbstractBuild<?, ?> build) {
        String charset = Mailer.descriptor().getCharset();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        String overrideCharset = descriptor.getCharset();
        if (overrideCharset != null) {
            charset = overrideCharset;
        }
        return charset;
    }
}

