/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.GroovyScriptPath;
import hudson.plugins.emailext.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class ExtendedEmailPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    private String defaultSuffix;
    private transient String hudsonUrl;
    private String smtpAuthUsername;
    private Secret smtpAuthPassword;
    private transient String adminAddress;
    private String smtpHost;
    private boolean useSsl;
    private String smtpPort;
    private String charset;
    private String defaultContentType;
    private String defaultSubject;
    private String defaultBody;
    private String defaultPresendScript = "";
    private List<GroovyScriptPath> defaultClasspath = new ArrayList<GroovyScriptPath>();
    private String emergencyReroute;
    private long maxAttachmentSize = -1L;
    private String recipientList = "";
    private String defaultReplyTo = "";
    private String excludedCommitters = "";
    private boolean overrideGlobalSettings;
    private String listId;
    private boolean precedenceBulk;
    private boolean debugMode = false;
    private boolean enableSecurity = false;
    private boolean requireAdminForTemplateTesting = false;
    private boolean enableWatching;

    public String getDisplayName() {
        return Messages.ExtendedEmailPublisherDescriptor_DisplayName();
    }

    public String getAdminAddress() {
        return JenkinsLocationConfiguration.get().getAdminAddress();
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public Session createSession() {
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        if (this.smtpPort != null) {
            props.put("mail.smtp.port", this.smtpPort);
        }
        if (this.useSsl) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                String port = this.smtpPort == null ? "465" : this.smtpPort;
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (this.smtpAuthUsername != null) {
            props.put("mail.smtp.auth", "true");
        }
        props.put("mail.smtp.timeout", "60000");
        props.put("mail.smtp.connectiontimeout", "60000");
        return Session.getInstance((Properties)props, (Authenticator)this.getAuthenticator());
    }

    private Authenticator getAuthenticator() {
        String un = this.getSmtpAuthUsername();
        if (un == null) {
            return null;
        }
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(ExtendedEmailPublisherDescriptor.this.getSmtpAuthUsername(), ExtendedEmailPublisherDescriptor.this.getSmtpAuthPassword());
            }
        };
    }

    public String getHudsonUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    public String getSmtpServer() {
        return this.smtpHost;
    }

    public String getSmtpAuthUsername() {
        return this.smtpAuthUsername;
    }

    public String getSmtpAuthPassword() {
        return Secret.toString((Secret)this.smtpAuthPassword);
    }

    public boolean getUseSsl() {
        return this.useSsl;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public String getCharset() {
        String c = this.charset;
        if (StringUtils.isBlank((String)c)) {
            c = "UTF-8";
        }
        return c;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public String getDefaultSubject() {
        return this.defaultSubject;
    }

    public String getDefaultBody() {
        return this.defaultBody;
    }

    public String getEmergencyReroute() {
        return this.emergencyReroute;
    }

    protected void setEmergencyReroute(String emergencyReroute) {
        this.emergencyReroute = emergencyReroute;
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public long getMaxAttachmentSizeMb() {
        return this.maxAttachmentSize / 0x100000L;
    }

    public String getDefaultRecipients() {
        return this.recipientList;
    }

    public String getExcludedCommitters() {
        return this.excludedCommitters;
    }

    public boolean getOverrideGlobalSettings() {
        return this.overrideGlobalSettings;
    }

    public String getListId() {
        return this.listId;
    }

    public boolean getPrecedenceBulk() {
        return this.precedenceBulk;
    }

    public String getDefaultReplyTo() {
        return this.defaultReplyTo;
    }

    public boolean isSecurityEnabled() {
        return this.enableSecurity;
    }

    public boolean isAdminRequiredForTemplateTesting() {
        return this.requireAdminForTemplateTesting;
    }

    public boolean isWatchingEnabled() {
        return this.enableWatching;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDefaultPresendScript() {
        return this.defaultPresendScript;
    }

    public List<GroovyScriptPath> getDefaultClasspath() {
        return this.defaultClasspath;
    }

    public ExtendedEmailPublisherDescriptor() {
        super(ExtendedEmailPublisher.class);
        this.load();
        if (this.defaultBody == null && this.defaultSubject == null && this.emergencyReroute == null) {
            this.defaultBody = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
            this.defaultSubject = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
            this.emergencyReroute = "";
            this.enableSecurity = false;
        }
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.overrideGlobalSettings = req.hasParameter("ext_mailer_override_global_settings");
        this.smtpHost = this.nullify(req.getParameter("ext_mailer_smtp_server"));
        this.defaultSuffix = this.nullify(req.getParameter("ext_mailer_default_suffix"));
        if (req.hasParameter("ext_mailer_use_smtp_auth")) {
            this.smtpAuthUsername = this.nullify(req.getParameter("ext_mailer_smtp_username"));
            this.smtpAuthPassword = Secret.fromString((String)this.nullify(req.getParameter("ext_mailer_smtp_password")));
        } else {
            this.smtpAuthUsername = null;
            this.smtpAuthPassword = null;
        }
        this.useSsl = req.hasParameter("ext_mailer_smtp_use_ssl");
        this.smtpPort = this.nullify(req.getParameter("ext_mailer_smtp_port"));
        this.charset = this.nullify(req.getParameter("ext_mailer_charset"));
        this.defaultContentType = this.nullify(req.getParameter("ext_mailer_default_content_type"));
        this.defaultSubject = this.nullify(req.getParameter("ext_mailer_default_subject"));
        this.defaultBody = this.nullify(req.getParameter("ext_mailer_default_body"));
        this.emergencyReroute = this.nullify(req.getParameter("ext_mailer_emergency_reroute"));
        this.defaultReplyTo = this.nullify(req.getParameter("ext_mailer_default_replyto")) != null ? req.getParameter("ext_mailer_default_replyto") : "";
        String string = this.defaultPresendScript = this.nullify(req.getParameter("ext_mailer_default_presend_script")) != null ? req.getParameter("ext_mailer_default_presend_script") : "";
        if (req.hasParameter("ext_mailer_default_classpath")) {
            this.defaultClasspath.clear();
            for (String s : req.getParameterValues("ext_mailer_default_classpath")) {
                this.defaultClasspath.add(new GroovyScriptPath(s));
            }
        }
        this.debugMode = req.hasParameter("ext_mailer_debug_mode");
        this.maxAttachmentSize = this.nullify(req.getParameter("ext_mailer_max_attachment_size")) != null ? Long.parseLong(req.getParameter("ext_mailer_max_attachment_size")) * 1024L * 1024L : -1L;
        this.recipientList = this.nullify(req.getParameter("ext_mailer_default_recipients")) != null ? req.getParameter("ext_mailer_default_recipients") : "";
        this.precedenceBulk = req.hasParameter("ext_mailer_add_precedence_bulk");
        this.enableSecurity = req.hasParameter("ext_mailer_security_enabled");
        this.excludedCommitters = req.getParameter("ext_mailer_excluded_committers");
        this.requireAdminForTemplateTesting = req.hasParameter("ext_mailer_require_admin_for_template_testing");
        this.enableWatching = req.hasParameter("ext_mailer_watching_enabled");
        this.listId = req.hasParameter("ext_mailer_use_list_id") ? this.nullify(req.getParameter("ext_mailer_list_id")) : null;
        this.save();
        return super.configure(req, formData);
    }

    private String nullify(String v) {
        if (v != null && v.length() == 0) {
            v = null;
        }
        return v;
    }

    public String getHelpFile() {
        return "/plugin/email-ext/help/main.html";
    }

    public FormValidation doAddressCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            new InternetAddress(value);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public FormValidation doRecipientListRecipientsCheck(@QueryParameter String value) throws IOException, ServletException {
        return new EmailRecipientUtils().validateFormRecipientList(value);
    }

    public FormValidation doMaxAttachmentSizeCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            String testValue = value.trim();
            if (testValue.length() > 0) {
                Long.parseLong(testValue);
            }
            return FormValidation.ok();
        }
        catch (Exception e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public boolean isMatrixProject(Object project) {
        return project instanceof MatrixProject;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void debug(PrintStream logger, String format, Object ... args) {
        if (this.debugMode) {
            logger.format(format, args);
            logger.println();
        }
    }
}

