/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RequesterRecipientProvider;
import hudson.scm.ChangeLogSet;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailingTestSuspectsRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public FailingTestSuspectsRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Debug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        HashSet users = null;
        AbstractBuild<?, ?> currentBuild = context.getBuild();
        if (currentBuild == null) {
            debug.send("currentBuild was null", new Object[0]);
        } else {
            AbstractTestResultAction testResultAction = (AbstractTestResultAction)currentBuild.getAction(AbstractTestResultAction.class);
            if (testResultAction == null) {
                debug.send("testResultAction was null", new Object[0]);
            } else if (testResultAction.getFailCount() <= 0) {
                debug.send("getFailCount() returned <= 0", new Object[0]);
            } else {
                users = new HashSet();
                debug.send("Collecting builds where a test started failing...", new Object[0]);
                HashSet<AbstractBuild> buildsWhereATestStartedFailing = new HashSet<AbstractBuild>();
                for (TestResult caseResult : testResultAction.getFailedTests()) {
                    Run runWhereTestStartedFailing = caseResult.getFailedSinceRun();
                    if (runWhereTestStartedFailing instanceof AbstractBuild) {
                        AbstractBuild buildWhereTestStartedFailing = (AbstractBuild)runWhereTestStartedFailing;
                        debug.send("  buildWhereTestStartedFailing: %d", buildWhereTestStartedFailing.getNumber());
                        buildsWhereATestStartedFailing.add(buildWhereTestStartedFailing);
                        continue;
                    }
                    debug.send("  runWhereTestStartedFailing was not an instance of AbstractBuild", new Object[0]);
                }
                debug.send("Collecting builds with suspects...", new Object[0]);
                HashSet<AbstractBuild> buildsWithSuspects = new HashSet<AbstractBuild>();
                block1: for (AbstractBuild buildWhereATestStartedFailing : buildsWhereATestStartedFailing) {
                    debug.send("  buildWhereATestStartedFailing: %d", buildWhereATestStartedFailing.getNumber());
                    buildsWithSuspects.add(buildWhereATestStartedFailing);
                    AbstractBuild previousBuildToCheck = (AbstractBuild)buildWhereATestStartedFailing.getPreviousCompletedBuild();
                    if (previousBuildToCheck != null) {
                        debug.send("    previousBuildToCheck: %d", previousBuildToCheck.getNumber());
                    }
                    while (previousBuildToCheck != null) {
                        if (buildsWithSuspects.contains(previousBuildToCheck)) {
                            debug.send("      already contained in buildsWithSuspects; stopping search", new Object[0]);
                            continue block1;
                        }
                        Result previousResult = previousBuildToCheck.getResult();
                        if (previousResult == null) {
                            debug.send("      previousResult was null", new Object[0]);
                            continue;
                        }
                        debug.send("      previousResult: %s", previousResult.toString());
                        if (previousResult.isBetterThan(Result.FAILURE)) {
                            debug.send("      previousResult was better than FAILURE; stopping search", new Object[0]);
                            continue block1;
                        }
                        debug.send("      previousResult was not better than FAILURE; adding to buildsWithSuspects; continuing search", new Object[0]);
                        buildsWithSuspects.add(previousBuildToCheck);
                        if ((previousBuildToCheck = (AbstractBuild)previousBuildToCheck.getPreviousCompletedBuild()) == null) continue;
                        debug.send("    previousBuildToCheck: %d", previousBuildToCheck.getNumber());
                    }
                }
                debug.send("Collecting suspects...", new Object[0]);
                for (AbstractBuild buildWithSuspects : buildsWithSuspects) {
                    debug.send("  buildWithSuspects: %d", buildWithSuspects.getNumber());
                    ChangeLogSet changeLogSet = buildWithSuspects.getChangeSet();
                    if (changeLogSet == null) {
                        debug.send("    changeLogSet was null", new Object[0]);
                    } else {
                        HashSet<User> changeAuthors = new HashSet<User>();
                        for (ChangeLogSet.Entry change : changeLogSet) {
                            User changeAuthor = change.getAuthor();
                            if (!changeAuthors.add(changeAuthor)) continue;
                            debug.send("    adding change author: %s", changeAuthor.getFullName());
                        }
                        users.addAll(changeAuthors);
                    }
                    User buildRequestor = RequesterRecipientProvider.getUserTriggeringTheBuild(buildWithSuspects);
                    if (buildRequestor != null) {
                        debug.send("    adding build requestor: %s", buildRequestor.getFullName());
                        users.add(buildRequestor);
                        continue;
                    }
                    debug.send("    buildRequestor was null", new Object[0]);
                }
            }
        }
        if (users != null) {
            for (User user : users) {
                if (EmailRecipientUtils.isExcludedRecipient(user, (TaskListener)context.getListener())) {
                    debug.send("User %s is an excluded recipient.", user.getFullName());
                    continue;
                }
                String userAddress = EmailRecipientUtils.getUserConfiguredEmail(user);
                if (userAddress != null) {
                    debug.send("Adding %s with address %s", user.getFullName(), userAddress);
                    EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, userAddress, env, (TaskListener)context.getListener());
                    continue;
                }
                context.getListener().getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        public String getDisplayName() {
            return "Suspects Causing Unit Tests to Begin Failing";
        }
    }
}

