/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovementTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Improvement";

    @DataBoundConstructor
    public ImprovementTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequestor, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(sendToList, sendToDevs, sendToRequestor, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        AbstractBuild<?, ?> previousBuild = ExtendedEmailPublisher.getPreviousBuild(build, listener);
        if (previousBuild == null) {
            return false;
        }
        if (build.getTestResultAction() == null) {
            return false;
        }
        if (previousBuild.getTestResultAction() == null) {
            return false;
        }
        int numCurrFailures = this.getNumFailures(build);
        return build.getTestResultAction().getTotalCount() > 0 && numCurrFailures < this.getNumFailures(previousBuild) && numCurrFailures > 0;
    }

    @Extension
    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Unstable");
            this.addTriggerNameToReplace("Still Unstable");
        }

        public String getDisplayName() {
            return ImprovementTrigger.TRIGGER_NAME;
        }

        public boolean getDefaultSendToDevs() {
            return true;
        }

        public boolean getDefaultSendToList() {
            return true;
        }
    }
}

