/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.AttachmentUtils;
import hudson.plugins.emailext.EmailExtTemplateAction;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.MatrixTriggerMode;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.CssInliner;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.content.TriggerNameContent;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.groovy.sandbox.SandboxTransformer;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmailPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisher.class.getName());
    private static final String CONTENT_TRANSFER_ENCODING = System.getProperty(ExtendedEmailPublisher.class.getName() + ".Content-Transfer-Encoding");
    public static final String DEFAULT_RECIPIENTS_TEXT = "";
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String DEFAULT_EMERGENCY_REROUTE_TEXT = "";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList = "";
    public List<EmailTrigger> configuredTriggers = new ArrayList<EmailTrigger>();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    public String attachmentsPattern;
    public String presendScript;
    public boolean attachBuildLog;
    public boolean compressBuildLog;
    public String replyTo;
    public boolean saveOutput = false;
    public MatrixTriggerMode matrixTriggerMode;

    @DataBoundConstructor
    public ExtendedEmailPublisher(String project_recipient_list, String project_content_type, String project_default_subject, String project_default_content, String project_attachments, String project_presend_script, int project_attach_buildlog, String project_replyto, boolean project_save_output, List<EmailTrigger> project_triggers, MatrixTriggerMode matrixTriggerMode) {
        this.recipientList = project_recipient_list;
        this.contentType = project_content_type;
        this.defaultSubject = project_default_subject;
        this.defaultContent = project_default_content;
        this.attachmentsPattern = project_attachments;
        this.presendScript = project_presend_script;
        this.attachBuildLog = project_attach_buildlog > 0;
        this.compressBuildLog = project_attach_buildlog > 1;
        this.replyTo = project_replyto;
        this.saveOutput = project_save_output;
        this.configuredTriggers = project_triggers;
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public ExtendedEmailPublisher() {
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList<EmailTrigger>();
        }
        return this.configuredTriggers;
    }

    public MatrixTriggerMode getMatrixTriggerMode() {
        return this.matrixTriggerMode == null ? MatrixTriggerMode.BOTH : this.matrixTriggerMode;
    }

    public void setMatrixTriggerMode(MatrixTriggerMode matrixTriggerMode) {
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public void debug(PrintStream p, String format, Object ... args) {
        this.getDescriptor().debug(p, format, args);
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        if (project.hasPermission(Item.CONFIGURE)) {
            return Collections.singletonList(new EmailExtTemplateAction(project));
        }
        return Collections.EMPTY_LIST;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.debug(listener.getLogger(), "Checking for pre-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Executing pre-build step", new Object[0]);
            return this._perform(build, listener, true);
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.debug(listener.getLogger(), "Checking for post-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Performing post-build step", new Object[0]);
            return this._perform(build, listener, false);
        }
        return true;
    }

    private boolean _perform(AbstractBuild<?, ?> build, BuildListener listener, boolean forPreBuild) {
        boolean emailTriggered = false;
        this.debug(listener.getLogger(), "Checking if email needs to be generated", new Object[0]);
        ArrayListMultimap triggered = ArrayListMultimap.create();
        for (EmailTrigger trigger : this.getConfiguredTriggers()) {
            if (trigger.isPreBuild() != forPreBuild || !trigger.trigger(build, (TaskListener)listener)) continue;
            Object tName = trigger.getDescriptor().getDisplayName();
            triggered.put(tName, (Object)trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList<String> replacedTriggers = new ArrayList<String>();
        for (Object tName : triggered.keySet()) {
            String triggerName = (String)tName;
            for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                replacedTriggers.addAll(trigger.getDescriptor().getTriggerReplaceList());
            }
        }
        for (String triggerName : replacedTriggers) {
            triggered.removeAll((Object)triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        for (String triggerName : triggered.keySet()) {
            for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                listener.getLogger().println("Sending email for trigger: " + triggerName);
                ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(this, build, (TaskListener)listener);
                context.setTriggered((Multimap<String, EmailTrigger>)triggered);
                context.setTrigger(trigger);
                this.sendMail(context);
            }
        }
        return true;
    }

    private boolean sendMail(ExtendedEmailPublisherContext context) {
        try {
            MimeMessage msg = this.createMail(context);
            this.debug(context.getListener().getLogger(), "Successfully created MimeMessage", new Object[0]);
            Address[] allRecipients = msg.getAllRecipients();
            int retries = 0;
            if (allRecipients != null) {
                StringBuilder buf = new StringBuilder("Sending email to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                context.getListener().getLogger().println(buf);
                if (this.executePresendScript(context, msg)) {
                    while (true) {
                        try {
                            Transport.send((Message)msg);
                        }
                        catch (SendFailedException e) {
                            if (e.getNextException() == null || !(e.getNextException() instanceof SocketException) && !(e.getNextException() instanceof ConnectException)) {
                                Address a2;
                                int i$;
                                Address[] addresses = e.getValidSentAddresses();
                                if (addresses != null && addresses.length > 0) {
                                    buf = new StringBuilder("Successfully sent to the following addresses:");
                                    Address[] arr$ = addresses;
                                    int len$ = arr$.length;
                                    for (i$ = 0; i$ < len$; ++i$) {
                                        a2 = arr$[i$];
                                        buf.append(' ').append(a2);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                if ((addresses = e.getValidUnsentAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following VALID addresses:");
                                    Address[] arr$ = addresses;
                                    int len$ = arr$.length;
                                    for (i$ = 0; i$ < len$; ++i$) {
                                        a2 = arr$[i$];
                                        buf.append(' ').append(a2);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                if ((addresses = e.getInvalidAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following INVALID addresses:");
                                    for (Address a2 : addresses) {
                                        buf.append(' ').append(a2);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                this.debug(context.getListener().getLogger(), "SendFailedException message: " + e.getMessage(), new Object[0]);
                                break;
                            }
                            context.getListener().getLogger().println("Socket error sending email, retrying once more in 10 seconds...");
                            Thread.sleep(10000L);
                            if (++retries <= 1) continue;
                            context.getListener().getLogger().println("Failed after second try sending email");
                        }
                        break;
                    }
                    if (context.getBuild().getAction(MailMessageIdAction.class) == null) {
                        context.getBuild().addAction((Action)new MailMessageIdAction(msg.getMessageID()));
                    }
                } else {
                    context.getListener().getLogger().println("Email sending was cancelled by user script.");
                }
                return true;
            }
            context.getListener().getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(context.getListener().error("Could not send email as a part of the post-build publishers."));
        }
        this.debug(context.getListener().getLogger(), "Some error occured trying to send the email...check the Jenkins log", new Object[0]);
        return false;
    }

    private List<TokenMacro> getRuntimeMacros(ExtendedEmailPublisherContext context) {
        ArrayList<TokenMacro> macros = new ArrayList<TokenMacro>();
        macros.add(new TriggerNameContent(context.getTrigger().getDescriptor().getDisplayName()));
        return macros;
    }

    private boolean executePresendScript(ExtendedEmailPublisherContext context, MimeMessage msg) throws RuntimeException {
        boolean cancel = false;
        String script = new ContentBuilder().transformText(this.presendScript, context, this.getRuntimeMacros(context));
        if (StringUtils.isNotBlank((String)script)) {
            this.debug(context.getListener().getLogger(), "Executing pre-send script", new Object[0]);
            ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
            ScriptSandbox sandbox = null;
            CompilerConfiguration cc = new CompilerConfiguration();
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
            if (this.getDescriptor().isSecurityEnabled()) {
                this.debug(context.getListener().getLogger(), "Setting up sandbox for pre-send script", new Object[0]);
                cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
                sandbox = new ScriptSandbox();
            }
            Binding binding = new Binding();
            binding.setVariable("build", context.getBuild());
            binding.setVariable("msg", (Object)msg);
            binding.setVariable("logger", (Object)context.getListener().getLogger());
            binding.setVariable("cancel", (Object)cancel);
            binding.setVariable("trigger", (Object)context.getTrigger());
            binding.setVariable("triggered", (Object)ImmutableMultimap.copyOf(context.getTriggered()));
            GroovyShell shell = new GroovyShell(cl, binding, cc);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            if (sandbox != null) {
                sandbox.register();
            }
            try {
                Object output = shell.evaluate(script);
                if (output != null) {
                    pw.println("Result: " + output);
                    cancel = (Boolean)shell.getVariable("cancel");
                    this.debug(context.getListener().getLogger(), "Pre-send script set cancel to %b", cancel);
                }
            }
            catch (SecurityException e) {
                context.getListener().getLogger().println("Pre-send script tried to access secured objects: " + e.getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace(pw);
                context.getListener().getLogger().println(out.toString());
            }
            this.debug(context.getListener().getLogger(), out.toString(), new Object[0]);
        }
        return !cancel;
    }

    private MimeMessage createMail(ExtendedEmailPublisherContext context) throws MessagingException, IOException, InterruptedException {
        String listId;
        MailMessageIdAction b;
        AbstractBuild<?, ?> pb;
        String emergencyReroute;
        boolean isEmergencyReroute;
        String overrideCharset;
        MimeMessage msg;
        Session session;
        boolean overrideGlobalSettings = this.getDescriptor().getOverrideGlobalSettings();
        if (!overrideGlobalSettings) {
            this.debug(context.getListener().getLogger(), "NOT overriding default server settings, using Mailer to create session", new Object[0]);
            session = Mailer.descriptor().createSession();
            msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
        } else {
            this.debug(context.getListener().getLogger(), "Overriding default server settings, creating our own session", new Object[0]);
            session = this.getDescriptor().createSession();
            msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.getDescriptor().getAdminAddress()));
        }
        if (this.getDescriptor().isDebugMode()) {
            session.setDebugOut(context.getListener().getLogger());
        }
        String charset = Mailer.descriptor().getCharset();
        if (overrideGlobalSettings && StringUtils.isNotBlank((String)(overrideCharset = this.getDescriptor().getCharset()))) {
            this.debug(context.getListener().getLogger(), "Overriding charset %s", overrideCharset);
            charset = overrideCharset;
        }
        msg.addHeader("X-Jenkins-Job", context.getBuild().getProject().getDisplayName());
        if (context.getBuild().getResult() != null) {
            msg.addHeader("X-Jenkins-Result", context.getBuild().getResult().toString());
        }
        msg.setSentDate(new Date());
        this.setSubject(context, msg, charset);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)this.getContent(context, charset));
        AttachmentUtils attachments = new AttachmentUtils(this.attachmentsPattern);
        attachments.attach((Multipart)multipart, context);
        if (StringUtils.isNotBlank((String)context.getTrigger().getEmail().getAttachmentsPattern())) {
            AttachmentUtils typeAttachments = new AttachmentUtils(context.getTrigger().getEmail().getAttachmentsPattern());
            typeAttachments.attach((Multipart)multipart, context);
        }
        if (this.attachBuildLog || context.getTrigger().getEmail().getAttachBuildLog()) {
            this.debug(context.getListener().getLogger(), "Request made to attach build log", new Object[0]);
            AttachmentUtils.attachBuildLog(context, (Multipart)multipart, this.compressBuildLog || context.getTrigger().getEmail().getCompressBuildLog());
        }
        msg.setContent((Multipart)multipart);
        EnvVars env = null;
        try {
            env = context.getBuild().getEnvironment(context.getListener());
        }
        catch (Exception e) {
            context.getListener().getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        LinkedHashSet<InternetAddress> recipientAddresses = new LinkedHashSet<InternetAddress>();
        LinkedHashSet<InternetAddress> ccAddresses = new LinkedHashSet<InternetAddress>();
        if (context.getTrigger().getEmail().getSendToRecipientList()) {
            this.debug(context.getListener().getLogger(), "Adding recipients from recipient list", new Object[0]);
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, this.getRecipientList(context, this.recipientList, charset), env, context.getListener());
        }
        if (context.getTrigger().getEmail().getSendToDevelopers()) {
            HashSet<User> users;
            this.debug(context.getListener().getLogger(), "Adding developers", new Object[0]);
            if (context.getTrigger().getEmail().getSendToCulprits()) {
                users = context.getBuild().getCulprits();
            } else {
                users = new HashSet<User>();
                for (ChangeLogSet.Entry change : context.getBuild().getChangeSet()) {
                    users.add(change.getAuthor());
                }
            }
            for (User user : users) {
                if (this.isExcludedRecipient(user, context.getListener())) continue;
                String userAddress = EmailRecipientUtils.getUserConfiguredEmail(user);
                if (userAddress != null) {
                    this.debug(context.getListener().getLogger(), "Adding user address %s, they were not considered an excluded committer", userAddress);
                    ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, userAddress, env, context.getListener());
                    continue;
                }
                context.getListener().getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (context.getTrigger().getEmail().getSendToRequester()) {
            AbstractProject p;
            this.debug(context.getListener().getLogger(), "Sending to requester", new Object[0]);
            AbstractBuild cur = context.getBuild();
            Cause.UpstreamCause upc = (Cause.UpstreamCause)context.getBuild().getCause(Cause.UpstreamCause.class);
            while (upc != null && (p = (AbstractProject)Jenkins.getInstance().getItemByFullName(upc.getUpstreamProject())) != null) {
                cur = p.getBuildByNumber(upc.getUpstreamBuild());
                upc = (Cause.UpstreamCause)cur.getCause(Cause.UpstreamCause.class);
            }
            this.addUserTriggeringTheBuild(cur, recipientAddresses, ccAddresses, env, context.getListener());
        }
        if (StringUtils.isNotBlank((String)context.getTrigger().getEmail().getRecipientList())) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, this.getRecipientList(context, context.getTrigger().getEmail().getRecipientList(), charset), env, context.getListener());
        }
        if (isEmergencyReroute = StringUtils.isNotBlank((String)(emergencyReroute = this.getDescriptor().getEmergencyReroute()))) {
            this.debug(context.getListener().getLogger(), "Emergency reroute turned on", new Object[0]);
            recipientAddresses.clear();
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, emergencyReroute, env, context.getListener());
            this.debug(context.getListener().getLogger(), "Emergency reroute is set to: " + emergencyReroute, new Object[0]);
        }
        LinkedHashSet<InternetAddress> excludedRecipients = new LinkedHashSet<InternetAddress>();
        for (InternetAddress recipient : recipientAddresses) {
            if (!this.isExcludedRecipient(recipient.getAddress(), context.getListener())) continue;
            excludedRecipients.add(recipient);
        }
        recipientAddresses.removeAll(excludedRecipients);
        ccAddresses.removeAll(excludedRecipients);
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
        if (ccAddresses.size() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses.toArray(new InternetAddress[ccAddresses.size()]));
        }
        LinkedHashSet<InternetAddress> replyToAddresses = new LinkedHashSet<InternetAddress>();
        if (StringUtils.isNotBlank((String)this.replyTo)) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(replyToAddresses, null, this.getRecipientList(context, this.replyTo, charset), env, context.getListener());
        }
        if (StringUtils.isNotBlank((String)context.getTrigger().getEmail().getReplyTo())) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(replyToAddresses, null, this.getRecipientList(context, context.getTrigger().getEmail().getReplyTo(), charset), env, context.getListener());
        }
        if (replyToAddresses.size() > 0) {
            msg.setReplyTo((Address[])replyToAddresses.toArray(new InternetAddress[replyToAddresses.size()]));
        }
        if ((pb = ExtendedEmailPublisher.getPreviousBuild(context.getBuild(), context.getListener())) != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null && pb.getResult() != Result.SUCCESS) {
            this.debug(context.getListener().getLogger(), "Setting In-Reply-To since last build was not successful", new Object[0]);
            msg.setHeader("In-Reply-To", b.messageId);
            msg.setHeader("References", b.messageId);
        }
        if (CONTENT_TRANSFER_ENCODING != null) {
            msg.setHeader("Content-Transfer-Encoding", CONTENT_TRANSFER_ENCODING);
        }
        if ((listId = this.getDescriptor().getListId()) != null) {
            msg.setHeader("List-ID", listId);
        }
        if (this.getDescriptor().getPrecedenceBulk()) {
            msg.setHeader("Precedence", "bulk");
        }
        return msg;
    }

    private boolean isExcludedRecipient(String userName, TaskListener listener) {
        StringTokenizer tokens = new StringTokenizer(this.getDescriptor().getExcludedCommitters(), ",");
        while (tokens.hasMoreTokens()) {
            String check = tokens.nextToken().trim();
            this.debug(listener.getLogger(), "Checking '%s' against '%s' to see if they are excluded", userName, check);
            if (!check.equalsIgnoreCase(userName)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedRecipient(User user, TaskListener listener) {
        String[] testValues;
        for (String testValue : testValues = new String[]{user.getFullName(), user.getId(), user.getDisplayName()}) {
            if (testValue == null || !this.isExcludedRecipient(testValue, listener)) continue;
            return true;
        }
        return false;
    }

    private void addUserTriggeringTheBuild(AbstractBuild<?, ?> build, Set<InternetAddress> recipientAddresses, Set<InternetAddress> ccAddresses, EnvVars env, TaskListener listener) {
        User user = this.getByUserIdCause(build);
        if (user == null) {
            user = this.getByLegacyUserCause(build);
        }
        if (user != null) {
            String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
            if (adrs != null) {
                ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, adrs, env, listener);
            } else {
                listener.getLogger().println("The user does not have a configured email address, trying the user's id");
                ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, user.getId(), env, listener);
            }
        }
    }

    private User getByUserIdCause(AbstractBuild<?, ?> build) {
        try {
            Class<?> userIdCause = ExtendedEmailPublisher.class.getClassLoader().loadClass("hudson.model.Cause$UserIdCause");
            Method getUserId = userIdCause.getMethod("getUserId", new Class[0]);
            Cause cause = build.getCause(userIdCause);
            if (cause != null) {
                String id = (String)getUserId.invoke((Object)cause, new Object[0]);
                return User.get((String)id, (boolean)false);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private User getByLegacyUserCause(AbstractBuild<?, ?> build) {
        try {
            Cause.UserCause userCause = (Cause.UserCause)build.getCause(Cause.UserCause.class);
            if (userCause != null) {
                Field authenticationName = Cause.UserCause.class.getDeclaredField("authenticationName");
                authenticationName.setAccessible(true);
                String name = (String)authenticationName.get(userCause);
                return User.get((String)name, (boolean)false);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private void setSubject(ExtendedEmailPublisherContext context, MimeMessage msg, String charset) throws MessagingException {
        String subject = new ContentBuilder().transformText(context.getTrigger().getEmail().getSubject(), context, this.getRuntimeMacros(context));
        msg.setSubject(subject, charset);
    }

    private String getRecipientList(ExtendedEmailPublisherContext context, String recipients, String charset) throws MessagingException {
        String recipientsTransformed = StringUtils.isBlank((String)recipients) ? "" : new ContentBuilder().transformText(recipients, context, this.getRuntimeMacros(context));
        return recipientsTransformed;
    }

    public boolean isExecuteOnMatrixNodes() {
        MatrixTriggerMode mtm = this.getMatrixTriggerMode();
        return MatrixTriggerMode.BOTH == mtm || MatrixTriggerMode.ONLY_CONFIGURATIONS == mtm;
    }

    private MimeBodyPart getContent(ExtendedEmailPublisherContext context, String charset) throws MessagingException {
        String messageContentType;
        String text = new ContentBuilder().transformText(context.getTrigger().getEmail().getBody(), context, this.getRuntimeMacros(context));
        String string = messageContentType = context.getTrigger().getEmail().getContentType().equals("project") ? this.contentType : context.getTrigger().getEmail().getContentType();
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = this.getDescriptor().getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        messageContentType = messageContentType + "; charset=" + charset;
        try {
            if (this.saveOutput) {
                Random random = new Random();
                String extension = ".html";
                if (messageContentType.startsWith("text/plain")) {
                    extension = ".txt";
                }
                FilePath savedOutput = new FilePath(context.getBuild().getWorkspace(), String.format("%s-%s%d%s", context.getTrigger().getDescriptor().getDisplayName(), context.getBuild().getId(), random.nextInt(), extension));
                savedOutput.write(text, charset);
            }
        }
        catch (IOException e) {
            context.getListener().getLogger().println("Error trying to save email output to file. " + e.getMessage());
        }
        catch (InterruptedException e) {
            context.getListener().getLogger().println("Error trying to save email output to file. " + e.getMessage());
        }
        MimeBodyPart msgPart = new MimeBodyPart();
        this.debug(context.getListener().getLogger(), "messageContentType = %s", messageContentType);
        if (messageContentType.startsWith("text/html")) {
            String inlinedCssHtml = new CssInliner().process(text);
            msgPart.setContent((Object)inlinedCssHtml, messageContentType);
        } else {
            msgPart.setContent((Object)text, messageContentType);
        }
        return msgPart;
    }

    private static void addAddressesFromRecipientList(Set<InternetAddress> addresses, Set<InternetAddress> ccAddresses, String recipientList, EnvVars envVars, TaskListener listener) {
        try {
            Set<InternetAddress> internetAddresses = new EmailRecipientUtils().convertRecipientString(recipientList, envVars, 0);
            addresses.addAll(internetAddresses);
            if (ccAddresses != null) {
                Set<InternetAddress> ccInternetAddresses = new EmailRecipientUtils().convertRecipientString(recipientList, envVars, 1);
                ccAddresses.addAll(ccInternetAddresses);
            }
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + ae.getRef());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Could not create email address.", e);
            listener.getLogger().println("Failed to create e-mail address because of invalid encoding");
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @CheckForNull
    public static AbstractBuild<?, ?> getPreviousBuild(@Nonnull AbstractBuild<?, ?> build, TaskListener listener) {
        AbstractBuild previousBuild = build.getPreviousBuild();
        if (previousBuild != null && previousBuild.isBuilding()) {
            listener.getLogger().println(Messages.ExtendedEmailPublisher__is_still_in_progress_ignoring_for_purpo(previousBuild.getDisplayName()));
            return null;
        }
        return previousBuild;
    }

    public ExtendedEmailPublisherDescriptor getDescriptor() {
        return (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public MatrixAggregator createAggregator(MatrixBuild matrixbuild, Launcher launcher, BuildListener buildlistener) {
        return new MatrixAggregator(matrixbuild, launcher, buildlistener){

            public boolean endBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of " + this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.listener, false);
                }
                return true;
            }

            public boolean startBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of " + this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.listener, true);
                }
                return true;
            }
        };
    }
}

