/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatusContent
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_STATUS";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        if (build.isBuilding() && null == build.getResult()) {
            return "Building";
        }
        Result buildResult = build.getResult();
        if (buildResult == Result.FAILURE) {
            AbstractBuild<?, ?> prevBuild = ExtendedEmailPublisher.getPreviousBuild(build, listener);
            if (prevBuild == null || prevBuild.getResult() != Result.FAILURE) return "Failure";
            return "Still Failing";
        }
        if (buildResult == Result.UNSTABLE) {
            AbstractBuild<?, ?> prevBuild = ExtendedEmailPublisher.getPreviousBuild(build, listener);
            if (prevBuild == null) return "Unstable";
            if (prevBuild.getResult() == Result.UNSTABLE) {
                return "Still Unstable";
            }
            if (prevBuild.getResult() == Result.SUCCESS) {
                return "Unstable";
            }
            if (prevBuild.getResult() != Result.FAILURE && prevBuild.getResult() != Result.ABORTED && prevBuild.getResult() != Result.NOT_BUILT) return "Unknown";
            AbstractBuild<?, ?> previous = ExtendedEmailPublisher.getPreviousBuild(prevBuild, listener);
            while (previous != null) {
                if (previous.getResult() == Result.SUCCESS) {
                    return "Unstable";
                }
                if (previous.getResult() == Result.UNSTABLE) {
                    return "Still unstable";
                }
                previous = ExtendedEmailPublisher.getPreviousBuild(previous, listener);
            }
            return "Unstable";
        }
        if (buildResult == Result.SUCCESS) {
            AbstractBuild<?, ?> prevBuild = ExtendedEmailPublisher.getPreviousBuild(build, listener);
            if (prevBuild == null || prevBuild.getResult() != Result.UNSTABLE && prevBuild.getResult() != Result.FAILURE) return "Successful";
            return "Fixed";
        }
        if (buildResult == Result.NOT_BUILT) {
            return "Not Built";
        }
        if (buildResult != Result.ABORTED) return "Unknown";
        return "Aborted";
    }
}

