/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.content.JellyScriptContent;
import hudson.plugins.emailext.plugins.content.ScriptContent;
import hudson.util.FormValidation;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailExtTemplateAction
implements Action {
    private AbstractProject<?, ?> project;

    public EmailExtTemplateAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return "/plugin/email-ext/images/template-debugger.png";
    }

    public String getDisplayName() {
        return Messages.EmailExtTemplateAction_DisplayName();
    }

    public String getUrlName() {
        return "templateTest";
    }

    private String renderError(Exception ex) {
        StringBuilder builder = new StringBuilder();
        builder.append("<h3>An error occured trying to render the template:</h3><br/>");
        builder.append("<span style=\"color:red; font-weight:bold\">");
        builder.append(ex.toString().replace("\n", "<br/>"));
        builder.append("</span>");
        return builder.toString();
    }

    public FormValidation doTemplateFileCheck(@QueryParameter String value) {
        File scriptsFolder;
        File scriptFile;
        if (!StringUtils.isEmpty((String)value) && !(scriptFile = new File(scriptsFolder = new File(Hudson.getInstance().getRootDir(), "email-templates"), value)).exists()) {
            return FormValidation.error((String)("The file '" + value + "' does not exist"));
        }
        return FormValidation.ok();
    }

    @JavaScriptMethod
    public String renderTemplate(String templateFile, String buildId) {
        String result;
        try {
            AbstractBuild build = this.project.getBuild(buildId);
            if (templateFile.endsWith(".jelly")) {
                JellyScriptContent jellyContent = new JellyScriptContent();
                jellyContent.template = templateFile;
                result = jellyContent.evaluate(build, TaskListener.NULL, "JELLY_SCRIPT");
            } else {
                ScriptContent scriptContent = new ScriptContent();
                scriptContent.template = templateFile;
                result = scriptContent.evaluate(build, TaskListener.NULL, "SCRIPT");
            }
        }
        catch (Exception ex) {
            result = this.renderError(ex);
        }
        return result;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }
}

