/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.TaskListener;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmailTrigger
implements Describable<EmailTrigger>,
ExtensionPoint {
    private EmailType email;

    public static DescriptorExtensionList<EmailTrigger, EmailTriggerDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(EmailTrigger.class);
    }

    protected EmailTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequestor, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog) {
        this.email = new EmailType();
        this.email.setSendToRecipientList(sendToList);
        this.email.setSendToDevelopers(sendToDevs);
        this.email.setSendToRequester(sendToRequestor);
        this.email.setRecipientList(recipientList);
        this.email.setReplyTo(replyTo);
        this.email.setSubject(subject);
        this.email.setBody(body);
        this.email.setAttachmentsPattern(attachmentsPattern);
        this.email.setAttachBuildLog(attachBuildLog > 0);
        this.email.setCompressBuildLog(attachBuildLog > 1);
    }

    protected EmailTrigger(JSONObject formData) {
    }

    public abstract boolean trigger(AbstractBuild<?, ?> var1, TaskListener var2);

    public EmailType getEmail() {
        return this.email;
    }

    public void setEmail(EmailType email) {
        if (email == null) {
            email = new EmailType();
            email.setBody("$PROJECT_DEFAULT_CONTENT");
            email.setSubject("$PROJECT_DEFAULT_SUBJECT");
        }
        this.email = email;
    }

    public EmailTriggerDescriptor getDescriptor() {
        return (EmailTriggerDescriptor)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        this.setEmail(this.createMailType(formData));
        return true;
    }

    protected int getNumFailures(AbstractBuild<?, ?> build) {
        AbstractTestResultAction a = build.getTestResultAction();
        if (a instanceof AggregatedTestResultAction) {
            int result = 0;
            AggregatedTestResultAction action = (AggregatedTestResultAction)a;
            for (AggregatedTestResultAction.ChildReport cr : action.getChildReports()) {
                if (cr == null || cr.child == null || cr.child.getParent() == null || !((AbstractProject)cr.child.getParent()).equals(build.getParent()) || !(cr.result instanceof TestResult)) continue;
                TestResult tr = (TestResult)cr.result;
                result += tr.getFailCount();
            }
            if (result == 0 && action.getFailCount() > 0) {
                result = action.getFailCount();
            }
            return result;
        }
        return a.getFailCount();
    }

    public boolean isPreBuild() {
        return false;
    }

    protected EmailType createMailType(JSONObject formData) {
        EmailType m = new EmailType();
        String prefix = "mailer_" + this.getDescriptor().getJsonSafeClassName() + '_';
        m.setSubject(formData.getString(prefix + "subject"));
        m.setBody(formData.getString(prefix + "body"));
        m.setRecipientList(formData.getString(prefix + "recipientList"));
        m.setSendToRecipientList(formData.optBoolean(prefix + "sendToRecipientList"));
        m.setSendToDevelopers(formData.optBoolean(prefix + "sendToDevelopers"));
        m.setSendToRequester(formData.optBoolean(prefix + "sendToRequester"));
        m.setIncludeCulprits(formData.optBoolean(prefix + "includeCulprits"));
        m.setAttachmentsPattern(formData.getString(prefix + "attachmentsPattern"));
        m.setAttachBuildLog(formData.optBoolean(prefix + "attachBuildLog"));
        m.setReplyTo(formData.getString(prefix + "replyTo"));
        return m;
    }
}

