/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(ScriptContent.class.getName());
    public static final String SCRIPT_NAME_ARG = "script";
    public static final String SCRIPT_TEMPLATE_ARG = "template";
    private static final String DEFAULT_SCRIPT_NAME = "email-ext.groovy";
    private static final String DEFAULT_TEMPLATE_NAME = "groovy-html.template";
    private static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";

    @Override
    public String getToken() {
        return "SCRIPT";
    }

    @Override
    public String getHelpText() {
        StringBuilder helpText = new StringBuilder("Custom message content generated from a groovy script. Custom scripts should be placed in $JENKINS_HOME/email-templates. When using custom scripts, the script filename should be used for the \"script\" argument.\ntemplates and other items may be loaded using the\nhost.readFile(String fileName) function\nthe function will look in the resources for\nthe email-ext plugin first, and then in the $JENKINS_HOME/email-templates\ndirectory. No other directories will be searched.\n<ul>\n<li><i>script</i> - the script name.<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Defaults to \"email-ext.groovy\".</li>\n<li><i>template</i> - the template filename.<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Defaults to \"groovy-html.template\"</li>\n</ul>\n");
        return helpText.toString();
    }

    @Override
    public List<String> getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SCRIPT_NAME_ARG);
        args.add(SCRIPT_TEMPLATE_ARG);
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType type, Map<String, ?> args) throws IOException, InterruptedException {
        String result;
        InputStream inputStream;
        block7: {
            inputStream = null;
            result = "";
            String scriptName = EmailContent.Args.get(args, SCRIPT_NAME_ARG, "");
            String templateName = EmailContent.Args.get(args, SCRIPT_TEMPLATE_ARG, DEFAULT_TEMPLATE_NAME);
            try {
                if (!StringUtils.isEmpty((String)scriptName)) {
                    inputStream = this.getFileInputStream(scriptName);
                    result = this.executeScript(build, inputStream);
                    break block7;
                }
                inputStream = this.getFileInputStream(templateName);
                result = this.renderTemplate(build, inputStream);
            }
            catch (FileNotFoundException e) {
                String missingScriptError = this.generateMissingFile(scriptName, templateName);
                LOGGER.log(Level.SEVERE, missingScriptError);
                result = missingScriptError;
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (GroovyRuntimeException e2) {
                result = "Error in script or template: " + e2.toString();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    private String generateMissingFile(String script, String template) {
        if (!StringUtils.isEmpty((String)script)) {
            return "Script [" + script + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
        }
        return "Template [" + template + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    private InputStream getFileInputStream(String fileName) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName);
        if (inputStream == null) {
            File scriptsFolder = new File(Hudson.getInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
            File scriptFile = new File(scriptsFolder, fileName);
            inputStream = new FileInputStream(scriptFile);
        }
        return inputStream;
    }

    private String renderTemplate(AbstractBuild<?, ?> build, InputStream templateStream) throws IOException {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("build", build);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("project", build.getParent());
        binding.put("rooturl", ExtendedEmailPublisher.DESCRIPTOR.getHudsonUrl());
        for (EmailContent content : ContentBuilder.getEmailContentTypes()) {
            binding.put(content.getToken(), (Object)new ContentClosure(content, build));
        }
        GroovyShell shell = this.createEngine(Collections.EMPTY_MAP);
        SimpleTemplateEngine engine = new SimpleTemplateEngine(shell);
        Writable w = engine.createTemplate((Reader)new InputStreamReader(templateStream)).make(binding);
        StringWriter content = new StringWriter();
        w.writeTo((Writer)content);
        return content.toString();
    }

    private GroovyShell createEngine(Map<String, Object> variables) throws FileNotFoundException, IOException {
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        ScriptSandbox sandbox = null;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        if (ExtendedEmailPublisher.DESCRIPTOR.isSecurityEnabled()) {
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
            sandbox = new ScriptSandbox();
        }
        Binding binding = new Binding();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            binding.setVariable(e.getKey(), e.getValue());
        }
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        if (sandbox != null) {
            sandbox.register();
        }
        return shell;
    }

    private String executeScript(AbstractBuild<?, ?> build, InputStream scriptStream) throws IOException {
        String result = "";
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("build", build);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("project", build.getParent());
        binding.put("rooturl", ExtendedEmailPublisher.DESCRIPTOR.getHudsonUrl());
        GroovyShell shell = this.createEngine(binding);
        Object res = shell.evaluate((Reader)new InputStreamReader(scriptStream));
        if (res != null) {
            result = res.toString();
        }
        return result;
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentClosure
    extends Closure {
        private EmailContent content;
        private AbstractBuild<?, ?> build;

        public ContentClosure(EmailContent content, AbstractBuild<?, ?> build) {
            super((Object)content);
            this.content = content;
            this.build = build;
        }

        public Object doCall(Object params) {
            String result;
            try {
                Map args = (Map)params;
                result = this.content.getContent(this.build, null, null, args);
            }
            catch (Exception e) {
                result = "[Error processing token: " + this.content.getToken() + "]";
            }
            return result;
        }
    }
}

