/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class CssInliner {
    public static final String CSS_STYLE = "cssstyle";
    public static final String STYLE_ATTR = "style";
    public static final String STYLE_TAG = "style";
    public static final String IMG_TAG = "img";
    public static final String IMG_SRC_ATTR = "src";

    private static String concatenateProperties(String oldProp, String newProp) {
        if (!oldProp.endsWith(";")) {
            oldProp = oldProp + ";";
        }
        return oldProp.trim() + " " + newProp.trim() + ";";
    }

    private String fetchStyles(Document doc) {
        Elements els = doc.select("style");
        StringBuilder styles = new StringBuilder();
        for (Element e : els) {
            if (!e.attr("data-inline").equals("true")) continue;
            styles.append(e.data());
            e.remove();
        }
        return styles.toString();
    }

    public String process(String input) {
        Document doc = Jsoup.parse((String)input);
        this.extractStyles(doc);
        this.applyStyles(doc);
        this.inlineImages(doc);
        String output = doc.toString();
        return output;
    }

    private void inlineImages(Document doc) {
        Elements allImages = doc.getElementsByTag(IMG_TAG);
        for (Element img : allImages) {
            if (!img.attr("data-inline").equals("true")) continue;
            String src = img.attr(IMG_SRC_ATTR);
            try {
                URL url = new URL(src);
                URLConnection urlConnection = url.openConnection();
                urlConnection.connect();
                String contentType = urlConnection.getContentType();
                urlConnection.getContent();
                byte[] srcContent = IOUtils.toByteArray((InputStream)url.openStream());
                String base64 = new Base64().encodeToString(srcContent);
                img.attr(IMG_SRC_ATTR, MessageFormat.format("data:{0};base64,{1}", contentType, base64));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void applyStyles(Document doc) {
        Elements allStyledElements = doc.getElementsByAttribute(CSS_STYLE);
        for (Element e : allStyledElements) {
            String newStyle = e.attr(CSS_STYLE);
            String oldStyle = e.attr("style");
            e.attr("style", (newStyle + "; " + oldStyle).replace(";;", ";"));
            e.removeAttr(CSS_STYLE);
        }
    }

    private void extractStyles(Document doc) {
        String stylesheet = this.fetchStyles(doc);
        String trimmedStylesheet = stylesheet.replaceAll("\n", "").replaceAll("/\\*.*?\\*/", "").replaceAll(" +", " ");
        String styleRules = trimmedStylesheet.trim();
        String delims = "{}";
        StringTokenizer st = new StringTokenizer(styleRules, delims);
        while (st.countTokens() > 1) {
            String selector = st.nextToken();
            String properties = st.nextToken();
            Elements selectedElements = doc.select(selector);
            Iterator i$ = selectedElements.iterator();
            while (i$.hasNext()) {
                Element selElem;
                String oldProperties = (selElem = (Element)i$.next()).attr(CSS_STYLE);
                selElem.attr(CSS_STYLE, oldProperties.length() > 0 ? CssInliner.concatenateProperties(oldProperties, properties) : properties);
            }
        }
    }
}

