/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.AttachmentUtils;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.MatrixTriggerMode;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.CssInliner;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmailPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisher.class.getName());
    private static final String CONTENT_TRANSFER_ENCODING = System.getProperty(ExtendedEmailPublisher.class.getName() + ".Content-Transfer-Encoding");
    public static final Map<String, EmailTriggerDescriptor> EMAIL_TRIGGER_TYPE_MAP = new HashMap<String, EmailTriggerDescriptor>();
    public static final String DEFAULT_RECIPIENTS_TEXT = "";
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String DEFAULT_EMERGENCY_REROUTE_TEXT = "";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList = "";
    public List<EmailTrigger> configuredTriggers = new ArrayList<EmailTrigger>();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    public String attachmentsPattern;
    public String presendScript;
    public boolean attachBuildLog;
    public boolean compressBuildLog;
    public String replyTo;
    private MatrixTriggerMode matrixTriggerMode;
    @Extension
    public static final ExtendedEmailPublisherDescriptor DESCRIPTOR = new ExtendedEmailPublisherDescriptor();

    public static void addEmailTriggerType(EmailTriggerDescriptor triggerType) throws EmailExtException {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            throw new EmailExtException("An email trigger type with name " + triggerType.getTriggerName() + " was already added.");
        }
        EMAIL_TRIGGER_TYPE_MAP.put(triggerType.getMailerId(), triggerType);
    }

    public static void removeEmailTriggerType(EmailTriggerDescriptor triggerType) {
        if (EMAIL_TRIGGER_TYPE_MAP.containsKey(triggerType.getMailerId())) {
            EMAIL_TRIGGER_TYPE_MAP.remove(triggerType.getMailerId());
        }
    }

    public static EmailTriggerDescriptor getEmailTriggerType(String mailerId) {
        return EMAIL_TRIGGER_TYPE_MAP.get(mailerId);
    }

    public static Collection<EmailTriggerDescriptor> getEmailTriggers() {
        return EMAIL_TRIGGER_TYPE_MAP.values();
    }

    public static Collection<String> getEmailTriggerNames() {
        return EMAIL_TRIGGER_TYPE_MAP.keySet();
    }

    public static List<EmailTrigger> getTriggersForNonConfiguredInstance() {
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            retList.add(EMAIL_TRIGGER_TYPE_MAP.get(mailerId).getNewInstance(null, null, null));
        }
        return retList;
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList<EmailTrigger>();
        }
        return this.configuredTriggers;
    }

    public List<EmailTrigger> getNonConfiguredTriggers() {
        List<EmailTrigger> confTriggers = this.getConfiguredTriggers();
        ArrayList<EmailTrigger> retList = new ArrayList<EmailTrigger>();
        for (String mailerId : EMAIL_TRIGGER_TYPE_MAP.keySet()) {
            boolean contains = false;
            for (EmailTrigger trigger : confTriggers) {
                if (!trigger.getDescriptor().getMailerId().equals(mailerId)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            retList.add(EMAIL_TRIGGER_TYPE_MAP.get(mailerId).getNewInstance(null, null, null));
        }
        return retList;
    }

    public boolean isConfigured() {
        return !this.getConfiguredTriggers().isEmpty();
    }

    public boolean getConfigured() {
        return this.isConfigured();
    }

    public MatrixTriggerMode getMatrixTriggerMode() {
        if (this.matrixTriggerMode == null) {
            return MatrixTriggerMode.BOTH;
        }
        return this.matrixTriggerMode;
    }

    public void setMatrixTriggerMode(MatrixTriggerMode matrixTriggerMode) {
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public void debug(PrintStream p, String format, Object ... args) {
        DESCRIPTOR.debug(p, format, args);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.debug(listener.getLogger(), "Checking for pre-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Executing pre-build step", new Object[0]);
            return this._perform(build, listener, true);
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.debug(listener.getLogger(), "Checking for post-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Performing post-build step", new Object[0]);
            return this._perform(build, listener, false);
        }
        return true;
    }

    private boolean _perform(AbstractBuild<?, ?> build, BuildListener listener, boolean forPreBuild) {
        boolean emailTriggered = false;
        this.debug(listener.getLogger(), "Checking if email needs to be generated", new Object[0]);
        HashMap<String, EmailTrigger> triggered = new HashMap<String, EmailTrigger>();
        for (EmailTrigger trigger : this.configuredTriggers) {
            if (trigger.isPreBuild() != forPreBuild || !trigger.trigger(build)) continue;
            String tName = trigger.getDescriptor().getTriggerName();
            triggered.put(tName, trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList<String> replacedTriggers = new ArrayList<String>();
        for (String triggerName : triggered.keySet()) {
            replacedTriggers.addAll(((EmailTrigger)triggered.get(triggerName)).getDescriptor().getTriggerReplaceList());
        }
        for (String triggerName : replacedTriggers) {
            triggered.remove(triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        for (String triggerName : triggered.keySet()) {
            listener.getLogger().println("Sending email for trigger: " + triggerName);
            this.sendMail(((EmailTrigger)triggered.get(triggerName)).getEmail(), build, listener);
        }
        return true;
    }

    private boolean sendMail(EmailType mailType, AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            MimeMessage msg = this.createMail(mailType, build, listener);
            this.debug(listener.getLogger(), "Successfully created MimeMessage", new Object[0]);
            Address[] allRecipients = msg.getAllRecipients();
            int retries = 0;
            if (allRecipients != null) {
                StringBuilder buf = new StringBuilder("Sending email to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                listener.getLogger().println(buf);
                if (this.executePresendScript(build, listener, msg)) {
                    while (true) {
                        try {
                            Transport.send((Message)msg);
                        }
                        catch (SendFailedException e) {
                            if (e.getNextException() == null || !(e.getNextException() instanceof SocketException) && !(e.getNextException() instanceof ConnectException)) {
                                Address a2;
                                int i$;
                                Address[] addresses = e.getValidSentAddresses();
                                if (addresses != null && addresses.length > 0) {
                                    buf = new StringBuilder("Successfully sent to the following addresses:");
                                    Address[] arr$ = addresses;
                                    int len$ = arr$.length;
                                    for (i$ = 0; i$ < len$; ++i$) {
                                        a2 = arr$[i$];
                                        buf.append(' ').append(a2);
                                    }
                                    listener.getLogger().println(buf);
                                }
                                if ((addresses = e.getValidUnsentAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following VALID addresses:");
                                    Address[] arr$ = addresses;
                                    int len$ = arr$.length;
                                    for (i$ = 0; i$ < len$; ++i$) {
                                        a2 = arr$[i$];
                                        buf.append(' ').append(a2);
                                    }
                                    listener.getLogger().println(buf);
                                }
                                if ((addresses = e.getInvalidAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following INVALID addresses:");
                                    for (Address a2 : addresses) {
                                        buf.append(' ').append(a2);
                                    }
                                    listener.getLogger().println(buf);
                                }
                                this.debug(listener.getLogger(), "SendFailedException message: " + e.getMessage(), new Object[0]);
                                break;
                            }
                            listener.getLogger().println("Socket error sending email, retrying once more in 10 seconds...");
                            Thread.sleep(10000L);
                            if (++retries <= 1) continue;
                            listener.getLogger().println("Failed after second try sending email");
                        }
                        break;
                    }
                    if (build.getAction(MailMessageIdAction.class) == null) {
                        build.addAction((Action)new MailMessageIdAction(msg.getMessageID()));
                    }
                } else {
                    listener.getLogger().println("Email sending was cancelled by user script.");
                }
                return true;
            }
            listener.getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(listener.error("Could not send email as a part of the post-build publishers."));
        }
        this.debug(listener.getLogger(), "Some error occured trying to send the email...check the Jenkins log", new Object[0]);
        return false;
    }

    private boolean executePresendScript(AbstractBuild<?, ?> build, BuildListener listener, MimeMessage msg) throws RuntimeException {
        boolean cancel = false;
        if (StringUtils.isNotBlank((String)this.presendScript)) {
            listener.getLogger().println("Executing pre-send script");
            ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
            ScriptSandbox sandbox = null;
            CompilerConfiguration cc = new CompilerConfiguration();
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
            if (DESCRIPTOR.isSecurityEnabled()) {
                this.debug(listener.getLogger(), "Setting up sandbox for pre-send script", new Object[0]);
                cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
                sandbox = new ScriptSandbox();
            }
            Binding binding = new Binding();
            binding.setVariable("build", build);
            binding.setVariable("msg", (Object)msg);
            binding.setVariable("logger", (Object)listener.getLogger());
            binding.setVariable("cancel", (Object)cancel);
            GroovyShell shell = new GroovyShell(cl, binding, cc);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            if (sandbox != null) {
                sandbox.register();
            }
            try {
                Object output = shell.evaluate(this.presendScript);
                if (output != null) {
                    pw.println("Result: " + output);
                    cancel = (Boolean)shell.getVariable("cancel");
                    this.debug(listener.getLogger(), "Pre-send script set cancel to %b", cancel);
                }
            }
            catch (SecurityException e) {
                listener.getLogger().println("Pre-send script tried to access secured objects: " + e.getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace(pw);
                listener.getLogger().println(out.toString());
            }
            this.debug(listener.getLogger(), out.toString(), new Object[0]);
        }
        return !cancel;
    }

    private MimeMessage createMail(EmailType type, AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, IOException, InterruptedException {
        String listId;
        MailMessageIdAction b;
        AbstractBuild pb;
        String emergencyReroute;
        boolean isEmergencyReroute;
        String overrideCharset;
        MimeMessage msg;
        boolean overrideGlobalSettings = DESCRIPTOR.getOverrideGlobalSettings();
        if (!overrideGlobalSettings) {
            this.debug(listener.getLogger(), "NOT overriding default server settings, using Mailer to create session", new Object[0]);
            msg = new MimeMessage(Mailer.descriptor().createSession());
            msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
        } else {
            this.debug(listener.getLogger(), "Overriding default server settings, creating our own session", new Object[0]);
            msg = new MimeMessage(DESCRIPTOR.createSession());
            msg.setFrom((Address)new InternetAddress(DESCRIPTOR.getAdminAddress()));
        }
        String charset = Mailer.descriptor().getCharset();
        if (overrideGlobalSettings && StringUtils.isNotBlank((String)(overrideCharset = DESCRIPTOR.getCharset()))) {
            this.debug(listener.getLogger(), "Overriding charset %s", overrideCharset);
            charset = overrideCharset;
        }
        msg.addHeader("X-Jenkins-Job", build.getProject().getDisplayName());
        if (build.getResult() != null) {
            msg.addHeader("X-Jenkins-Result", build.getResult().toString());
        }
        msg.setSentDate(new Date());
        this.setSubject(type, build, msg, listener, charset);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)this.getContent(type, build, msg, listener, charset));
        AttachmentUtils attachments = new AttachmentUtils(this.attachmentsPattern);
        attachments.attach((Multipart)multipart, this, build, listener);
        if (StringUtils.isNotBlank((String)type.getAttachmentsPattern())) {
            AttachmentUtils typeAttachments = new AttachmentUtils(type.getAttachmentsPattern());
            typeAttachments.attach((Multipart)multipart, this, build, listener);
        }
        if (this.attachBuildLog || type.getAttachBuildLog()) {
            this.debug(listener.getLogger(), "Request made to attach build log", new Object[0]);
            AttachmentUtils.attachBuildLog((Multipart)multipart, build, listener, this.compressBuildLog || type.getCompressBuildLog());
        }
        msg.setContent((Multipart)multipart);
        EnvVars env = null;
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        LinkedHashSet<InternetAddress> recipientAddresses = new LinkedHashSet<InternetAddress>();
        LinkedHashSet<InternetAddress> ccAddresses = new LinkedHashSet<InternetAddress>();
        if (type.getSendToRecipientList()) {
            this.debug(listener.getLogger(), "Adding recipients from recipient list", new Object[0]);
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, this.getRecipientList(type, build, this.recipientList, listener, charset), env, listener);
        }
        if (type.getSendToDevelopers()) {
            HashSet<User> users;
            this.debug(listener.getLogger(), "Adding developers", new Object[0]);
            if (type.getIncludeCulprits()) {
                users = build.getCulprits();
            } else {
                users = new HashSet<User>();
                for (ChangeLogSet.Entry change : build.getChangeSet()) {
                    users.add(change.getAuthor());
                }
            }
            for (User user : users) {
                String userAddress = EmailRecipientUtils.getUserConfiguredEmail(user);
                if (userAddress != null) {
                    ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, userAddress, env, listener);
                    continue;
                }
                listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (type.isSendToRequester()) {
            this.debug(listener.getLogger(), "Sending to requester", new Object[0]);
            AbstractBuild cur = build;
            Cause.UpstreamCause upc = (Cause.UpstreamCause)build.getCause(Cause.UpstreamCause.class);
            while (upc != null) {
                AbstractProject p = (AbstractProject)Hudson.getInstance().getItemByFullName(upc.getUpstreamProject());
                cur = (AbstractBuild)p.getBuildByNumber(upc.getUpstreamBuild());
                upc = (Cause.UpstreamCause)cur.getCause(Cause.UpstreamCause.class);
            }
            this.addUserTriggeringTheBuild(cur, recipientAddresses, ccAddresses, env, listener);
        }
        if (StringUtils.isNotBlank((String)type.getRecipientList())) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, this.getRecipientList(type, build, type.getRecipientList(), listener, charset), env, listener);
        }
        if (isEmergencyReroute = StringUtils.isNotBlank((String)(emergencyReroute = DESCRIPTOR.getEmergencyReroute()))) {
            this.debug(listener.getLogger(), "Emergency reroute turned on", new Object[0]);
            recipientAddresses.clear();
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, emergencyReroute, env, listener);
            listener.getLogger().println("Emergency reroute is set to: " + emergencyReroute);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
        if (ccAddresses.size() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses.toArray(new InternetAddress[ccAddresses.size()]));
        }
        LinkedHashSet<InternetAddress> replyToAddresses = new LinkedHashSet<InternetAddress>();
        if (StringUtils.isNotBlank((String)this.replyTo)) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(replyToAddresses, null, this.getRecipientList(type, build, this.replyTo, listener, charset), env, listener);
        }
        if (StringUtils.isNotBlank((String)type.getReplyTo())) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(replyToAddresses, null, this.getRecipientList(type, build, type.getReplyTo(), listener, charset), env, listener);
        }
        if (replyToAddresses.size() > 0) {
            msg.setReplyTo((Address[])replyToAddresses.toArray(new InternetAddress[replyToAddresses.size()]));
        }
        if ((pb = (AbstractBuild)build.getPreviousBuild()) != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null && pb.getResult() != Result.SUCCESS) {
            this.debug(listener.getLogger(), "Setting In-Reply-To since last build was not successful", new Object[0]);
            msg.setHeader("In-Reply-To", b.messageId);
            msg.setHeader("References", b.messageId);
        }
        if (CONTENT_TRANSFER_ENCODING != null) {
            msg.setHeader("Content-Transfer-Encoding", CONTENT_TRANSFER_ENCODING);
        }
        if ((listId = DESCRIPTOR.getListId()) != null) {
            msg.setHeader("List-ID", listId);
        }
        if (DESCRIPTOR.getPrecedenceBulk()) {
            msg.setHeader("Precedence", "bulk");
        }
        return msg;
    }

    private void addUserTriggeringTheBuild(AbstractBuild<?, ?> build, Set<InternetAddress> recipientAddresses, Set<InternetAddress> ccAddresses, EnvVars env, BuildListener listener) {
        User user = this.getByUserIdCause(build);
        if (user == null) {
            user = this.getByLegacyUserCause(build);
        }
        if (user != null) {
            String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
            if (adrs != null) {
                ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, adrs, env, listener);
            } else {
                listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
    }

    private User getByUserIdCause(AbstractBuild<?, ?> build) {
        try {
            Class<?> userIdCause = ExtendedEmailPublisher.class.getClassLoader().loadClass("hudson.model.Cause$UserIdCause");
            Method getUserId = userIdCause.getMethod("getUserId", new Class[0]);
            Cause cause = build.getCause(userIdCause);
            if (cause != null) {
                String id = (String)getUserId.invoke((Object)cause, new Object[0]);
                return User.get((String)id, (boolean)false);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private User getByLegacyUserCause(AbstractBuild<?, ?> build) {
        try {
            Cause.UserCause userCause = (Cause.UserCause)build.getCause(Cause.UserCause.class);
            if (userCause != null) {
                Field authenticationName = Cause.UserCause.class.getDeclaredField("authenticationName");
                authenticationName.setAccessible(true);
                String name = (String)authenticationName.get(userCause);
                return User.get((String)name, (boolean)false);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private void setSubject(EmailType type, AbstractBuild<?, ?> build, MimeMessage msg, BuildListener listener, String charset) throws MessagingException {
        String subject = new ContentBuilder().transformText(type.getSubject(), this, type, build, (TaskListener)listener);
        msg.setSubject(subject, charset);
    }

    private String getRecipientList(EmailType type, AbstractBuild<?, ?> build, String recipients, BuildListener listener, String charset) throws MessagingException {
        String recipientsTransformed = StringUtils.isBlank((String)recipients) ? "" : new ContentBuilder().transformText(recipients, this, type, build, (TaskListener)listener);
        return recipientsTransformed;
    }

    public boolean isExecuteOnMatrixNodes() {
        MatrixTriggerMode mtm = this.getMatrixTriggerMode();
        return MatrixTriggerMode.BOTH == mtm || MatrixTriggerMode.ONLY_CONFIGURATIONS == mtm;
    }

    private MimeBodyPart getContent(EmailType type, AbstractBuild<?, ?> build, MimeMessage msg, BuildListener listener, String charset) throws MessagingException {
        String text = new ContentBuilder().transformText(type.getBody(), this, type, build, (TaskListener)listener);
        String messageContentType = this.contentType;
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = DESCRIPTOR.getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        messageContentType = messageContentType + "; charset=" + charset;
        MimeBodyPart msgPart = new MimeBodyPart();
        this.debug(listener.getLogger(), "messageContentType = %s", messageContentType);
        if (messageContentType.startsWith("text/html")) {
            String inlinedCssHtml = new CssInliner().process(text);
            msgPart.setContent((Object)inlinedCssHtml, messageContentType);
        } else {
            msgPart.setContent((Object)text, messageContentType);
        }
        return msgPart;
    }

    private static void addAddressesFromRecipientList(Set<InternetAddress> addresses, Set<InternetAddress> ccAddresses, String recipientList, EnvVars envVars, BuildListener listener) {
        try {
            Set<InternetAddress> internetAddresses = new EmailRecipientUtils().convertRecipientString(recipientList, envVars, 0);
            addresses.addAll(internetAddresses);
            if (ccAddresses != null) {
                Set<InternetAddress> ccInternetAddresses = new EmailRecipientUtils().convertRecipientString(recipientList, envVars, 1);
                ccAddresses.addAll(ccInternetAddresses);
            }
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + ae.getRef());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Could not create email address.", e);
            listener.getLogger().println("Failed to create e-mail address because of invalid encoding");
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public MatrixAggregator createAggregator(MatrixBuild matrixbuild, Launcher launcher, BuildListener buildlistener) {
        return new MatrixAggregator(matrixbuild, launcher, buildlistener){

            public boolean endBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of " + this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.listener, false);
                }
                return true;
            }

            public boolean startBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of " + this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.listener, true);
                }
                return true;
            }
        };
    }

    public static final class DescriptorImpl
    extends ExtendedEmailPublisherDescriptor {
    }
}

