/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.model.User;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailRecipientUtils {
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    public static final int TO = 0;
    public static final int CC = 1;

    public Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars) throws AddressException, UnsupportedEncodingException {
        return this.convertRecipientString(recipientList, envVars, 0);
    }

    public Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars, int type) throws AddressException, UnsupportedEncodingException {
        LinkedHashSet<InternetAddress> internetAddresses = new LinkedHashSet<InternetAddress>();
        if (!StringUtils.isBlank((String)recipientList)) {
            String expandedRecipientList = this.fixupSpaces(envVars.expand(recipientList));
            InternetAddress[] all = InternetAddress.parse((String)expandedRecipientList.replace("cc:", ""));
            LinkedHashSet<InternetAddress> to = new LinkedHashSet<InternetAddress>();
            LinkedHashSet<InternetAddress> cc = new LinkedHashSet<InternetAddress>();
            String defaultSuffix = Mailer.descriptor().getDefaultSuffix();
            for (InternetAddress address : all) {
                if (address.getPersonal() != null) {
                    if (expandedRecipientList.contains("cc:" + address.getPersonal()) || expandedRecipientList.contains("cc:\"" + address.toString() + "\"")) {
                        cc.add(address);
                        continue;
                    }
                    to.add(address);
                    continue;
                }
                if (expandedRecipientList.contains("cc:" + address.toString())) {
                    cc.add(address);
                    continue;
                }
                to.add(address);
            }
            if (type == 1) {
                internetAddresses.addAll(cc);
            } else {
                internetAddresses.addAll(to);
            }
            for (InternetAddress address : internetAddresses) {
                if (!address.getAddress().contains("@")) {
                    User u = User.get((String)address.getAddress(), (boolean)false);
                    String userEmail = null;
                    if (u != null && (userEmail = EmailRecipientUtils.getUserConfiguredEmail(u)) != null) {
                        address.setAddress(userEmail);
                    }
                }
                if (!address.getAddress().contains("@") && defaultSuffix != null && defaultSuffix.contains("@")) {
                    address.setAddress(address.getAddress() + defaultSuffix);
                }
                if (address.getPersonal() == null) continue;
                address.setPersonal(MimeUtility.encodeWord((String)address.getPersonal(), (String)"UTF-8", (String)"B"));
            }
        }
        return internetAddresses;
    }

    public static String getUserConfiguredEmail(User user) {
        Mailer.UserProperty mailProperty;
        String addr = null;
        if (user != null && (mailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) != null) {
            addr = mailProperty.getAddress();
        }
        return addr;
    }

    public FormValidation validateFormRecipientList(String recipientList) {
        try {
            this.convertRecipientString(recipientList, new EnvVars(), 0);
            this.convertRecipientString(recipientList, new EnvVars(), 1);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)(e.getMessage() + ": \"" + e.getRef() + "\""));
        }
        catch (UnsupportedEncodingException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    private String fixupSpaces(String input) {
        if ((input = input.replaceAll("\\s+", " ")).contains(" ") && !input.contains(",")) {
            input = input.replace(" ", ",");
        }
        return input;
    }
}

