/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.Mailer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLogMultilineRegexContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    private static final String TOKEN = "BUILD_LOG_MULTILINE_REGEX";
    private static final String REGEX_ARG_NAME = "regex";
    private static final String MAX_MATCHES_ARG_NAME = "maxMatches";
    private static final int MAX_MATCHES_DEFAULT_VALUE = 0;
    private static final String SHOW_TRUNCATED_LINES_ARG_NAME = "showTruncatedLines";
    private static final boolean SHOW_TRUNCATED_LINES_DEFAULT_VALUE = true;
    private static final String SUBST_TEXT_ARG_NAME = "substText";
    private static final String SUBST_TEXT_DEFAULT_VALUE = null;
    private static final String ESCAPE_HTML_ARG_NAME = "escapeHtml";
    private static final boolean ESCAPE_HTML_DEFAULT_VALUE = false;
    private static final String MATCHED_SEGMENT_HTML_STYLE_ARG_NAME = "matchedSegmentHtmlStyle";
    private static final String MATCHED_SEGMENT_HTML_STYLE_DEFAULT_VALUE = null;
    private static final Pattern LINE_TERMINATOR_PATTERN = Pattern.compile("(?<=.)\\r?\\n");

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Arrays.asList(REGEX_ARG_NAME, MAX_MATCHES_ARG_NAME, SHOW_TRUNCATED_LINES_ARG_NAME, SUBST_TEXT_ARG_NAME, ESCAPE_HTML_ARG_NAME, MATCHED_SEGMENT_HTML_STYLE_ARG_NAME);
    }

    @Override
    public String getHelpText() {
        return "Displays build log segments that match the regular expression.\n<ul>\n<li><i>regex</i> - Segments of the build log that match this regular expression are included.  See also <a href=\"http://download.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html\"><i>java.util.regex.Pattern</i></a><br>\nNo default. Required parameter.<li><i>maxMatches</i> - The maximum number of matches to include. If 0, all matches will be included.<br>\nDefaults to 0.\n<li><i>showTruncatedLines</i> - If <i>true</i>, include <tt>[...truncated ### lines...]</tt> lines.<br>\nDefaults to true.\n<li><i>substText</i> - If non-null, insert this text into the email rather than the entire segment.<br>\nDefaults to null.\n<li><i>escapeHtml</i> - If true, escape HTML.<br>\nDefaults to false.\n<li><i>matchedSegmentHtmlStyle</i> - If non-null, output HTML. matched lines will become <code>&lt;b style=\"your-style-value\"&gt;html escaped matched line&lt;/b&gt;</code>.<br>\nDefaults to null.\n</ul>\n";
    }

    private boolean startPre(StringBuilder buffer, boolean insidePre) {
        if (!insidePre) {
            buffer.append("<pre>\n");
            insidePre = true;
        }
        return insidePre;
    }

    private boolean stopPre(StringBuilder buffer, boolean insidePre) {
        if (insidePre) {
            buffer.append("</pre>\n");
            insidePre = false;
        }
        return insidePre;
    }

    private void appendMatchedSegment(StringBuilder buffer, String segment, boolean escapeHtml, String style) {
        if (escapeHtml) {
            segment = StringEscapeUtils.escapeHtml((String)segment);
        }
        if (style != null) {
            buffer.append("<b");
            if (style.length() > 0) {
                buffer.append(" style=\"");
                buffer.append(style);
                buffer.append("\"");
            }
            buffer.append(">");
        }
        buffer.append(segment);
        if (style != null) {
            buffer.append("</b>");
        }
        buffer.append('\n');
    }

    private void appendLinesTruncated(StringBuilder buffer, int numLinesTruncated, boolean asHtml) {
        if (asHtml) {
            buffer.append("<p>");
        }
        buffer.append("[...truncated ");
        buffer.append(numLinesTruncated);
        buffer.append(" lines...]");
        if (asHtml) {
            buffer.append("</p>");
        }
        buffer.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        String string;
        BufferedReader reader = new BufferedReader(new FileReader(build.getLogFile()));
        try {
            string = this.getContent(reader, args);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                return "";
            }
        }
        reader.close();
        return string;
    }

    String getContent(BufferedReader reader, Map<String, ?> args) throws IOException {
        int numLinesTruncated;
        int ch;
        Pattern pattern = Pattern.compile((String)args.get(REGEX_ARG_NAME));
        int maxMatches = EmailContent.Args.get(args, MAX_MATCHES_ARG_NAME, 0);
        boolean showTruncatedLines = EmailContent.Args.get(args, SHOW_TRUNCATED_LINES_ARG_NAME, true);
        String substText = EmailContent.Args.get(args, SUBST_TEXT_ARG_NAME, SUBST_TEXT_DEFAULT_VALUE);
        String matchedSegmentHtmlStyle = EmailContent.Args.get(args, MATCHED_SEGMENT_HTML_STYLE_ARG_NAME, MATCHED_SEGMENT_HTML_STYLE_DEFAULT_VALUE);
        boolean asHtml = matchedSegmentHtmlStyle != null;
        boolean escapeHtml = asHtml || EmailContent.Args.get(args, ESCAPE_HTML_ARG_NAME, false);
        StringBuilder line = new StringBuilder();
        StringBuilder fullLog = new StringBuilder();
        while ((ch = reader.read()) != -1) {
            if (ch == 13 || ch == 10) {
                if (line.length() > 0) {
                    fullLog.append(ConsoleNote.removeNotes((String)line.toString()));
                    line.setLength(0);
                }
                fullLog.append((char)ch);
                continue;
            }
            line.append((char)ch);
        }
        if (line.length() > 0) {
            fullLog.append(ConsoleNote.removeNotes((String)line.toString()));
        }
        StringBuilder content = new StringBuilder();
        int numMatches = 0;
        boolean insidePre = false;
        int lastMatchEnd = 0;
        Matcher matcher = pattern.matcher(fullLog);
        while (matcher.find() && (maxMatches == 0 || ++numMatches <= maxMatches)) {
            int numLinesTruncated2;
            if (showTruncatedLines && matcher.start() > lastMatchEnd && (numLinesTruncated2 = this.countLineTerminators(fullLog.subSequence(lastMatchEnd, matcher.start()))) > 0) {
                insidePre = this.stopPre(content, insidePre);
                this.appendLinesTruncated(content, numLinesTruncated2, asHtml);
            }
            if (asHtml) {
                insidePre = this.startPre(content, insidePre);
            }
            if (substText != null) {
                StringBuffer substBuf = new StringBuffer();
                matcher.appendReplacement(substBuf, substText);
                String segment = substBuf.substring(matcher.start() - lastMatchEnd);
                this.appendMatchedSegment(content, segment, escapeHtml, matchedSegmentHtmlStyle);
            } else {
                this.appendMatchedSegment(content, matcher.group(), escapeHtml, matchedSegmentHtmlStyle);
            }
            lastMatchEnd = matcher.end();
        }
        if (showTruncatedLines && fullLog.length() > lastMatchEnd && (numLinesTruncated = this.countLineTerminators(fullLog.subSequence(lastMatchEnd, fullLog.length()))) > 0) {
            insidePre = this.stopPre(content, insidePre);
            this.appendLinesTruncated(content, numLinesTruncated, asHtml);
        }
        this.stopPre(content, insidePre);
        return content.toString();
    }

    private int countLineTerminators(CharSequence charSequence) {
        int lineTerminatorCount = 0;
        Matcher matcher = LINE_TERMINATOR_PATTERN.matcher(charSequence);
        while (matcher.find()) {
            ++lineTerminatorCount;
        }
        return lineTerminatorCount;
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

