/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptException;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(ScriptContent.class.getName());
    public static final String SCRIPT_NAME_ARG = "script";
    public static final String SCRIPT_TEMPLATE_ARG = "template";
    public static final String SCRIPT_INIT_ARG = "init";
    private static final String DEFAULT_SCRIPT_NAME = "email-ext.groovy";
    private static final String DEFAULT_TEMPLATE_NAME = "groovy-html.template";
    private static final boolean DEFAULT_INIT_VALUE = true;
    private static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";

    @Override
    public String getToken() {
        return "SCRIPT";
    }

    @Override
    public String getHelpText() {
        StringBuilder helpText = new StringBuilder("Custom message content generated from a groovy script. Custom scripts should be placed in $JENKINS_HOME/email-templates. When using custom scripts, the script filename should be used for the \"script\" argument.\ntemplates and other items may be loaded using the\nhost.readFile(String fileName) function\nthe function will look in the resources for\nthe email-ext plugin first, and then in the $JENKINS_HOME/email-templates\ndirectory. No other directories will be searched.\n<ul>\n<li><i>script</i> - the script name.<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Defaults to \"email-ext.groovy\".</li>\n<li><i>template</i> - the template filename.<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Defaults to \"groovy-html.template\"</li>\n<li><i>init</i> - true to run the language's init script.<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Defaults to true</li>\n</ul>\n");
        return helpText.toString();
    }

    @Override
    public List<String> getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SCRIPT_NAME_ARG);
        args.add(SCRIPT_TEMPLATE_ARG);
        args.add(SCRIPT_INIT_ARG);
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType type, Map<String, ?> args) throws IOException, InterruptedException {
        InputStream inputStream = null;
        InputStream templateStream = null;
        String scriptName = EmailContent.Args.get(args, SCRIPT_NAME_ARG, DEFAULT_SCRIPT_NAME);
        String templateName = EmailContent.Args.get(args, SCRIPT_TEMPLATE_ARG, DEFAULT_TEMPLATE_NAME);
        boolean runInit = EmailContent.Args.get(args, SCRIPT_INIT_ARG, true);
        try {
            inputStream = this.getFileInputStream(scriptName);
            templateStream = this.getFileInputStream(templateName);
            IOUtils.closeQuietly((InputStream)templateStream);
            String string = this.renderContent(build, publisher, inputStream, scriptName, templateName, runInit);
            return string;
        }
        catch (FileNotFoundException e) {
            String missingScriptError = this.generateMissingFile(scriptName, templateName);
            LOGGER.log(Level.SEVERE, missingScriptError);
            String string = missingScriptError;
            return string;
        }
        catch (ScriptException e) {
            LOGGER.log(Level.SEVERE, null, e);
            String string = "Exception: " + e.getMessage();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private String generateMissingFile(String script, String template) {
        return "Script [" + script + "] or template [" + template + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    private InputStream getFileInputStream(String fileName) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName);
        if (inputStream == null) {
            File scriptsFolder = new File(Hudson.getInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
            File scriptFile = new File(scriptsFolder, fileName);
            inputStream = new FileInputStream(scriptFile);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderContent(AbstractBuild<?, ?> build, ExtendedEmailPublisher publisher, InputStream inputStream, String scriptName, String templateName, boolean runInit) throws ScriptException, IOException {
        String rendered = "";
        GroovyShell engine = this.createEngine(scriptName, templateName, runInit, new ScriptContentBuildWrapper(build), build, publisher);
        if (engine != null) {
            try {
                Object res = engine.evaluate((Reader)new InputStreamReader(inputStream));
                if (res != null) {
                    rendered = res.toString();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return rendered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String fileName) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        String result = "";
        InputStream inputStream = this.getFileInputStream(fileName);
        if (inputStream != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[2048];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
                result = ((Object)writer).toString();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroovyShell createEngine(String scriptName, String templateName, boolean runInit, Object it, AbstractBuild<?, ?> build, ExtendedEmailPublisher publisher) throws FileNotFoundException, IOException {
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        ScriptSandbox sandbox = null;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        if (ExtendedEmailPublisher.DESCRIPTOR.isSecurityEnabled()) {
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
            sandbox = new ScriptSandbox();
        }
        Binding binding = new Binding();
        binding.setVariable("build", build);
        binding.setVariable("it", it);
        binding.setVariable("project", (Object)build.getParent());
        binding.setVariable("rooturl", (Object)ExtendedEmailPublisher.DESCRIPTOR.getHudsonUrl());
        binding.setVariable("host", (Object)this);
        binding.setVariable("publisher", (Object)publisher);
        binding.setVariable(SCRIPT_TEMPLATE_ARG, (Object)templateName);
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        if (sandbox != null) {
            sandbox.register();
        }
        if (runInit) {
            InputStream initFile = null;
            try {
                initFile = this.getFileInputStream("groovy/init.groovy");
                if (initFile != null) {
                    shell.evaluate((Reader)new InputStreamReader(initFile));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception on init file: {0}", e.toString());
            }
            finally {
                IOUtils.closeQuietly((InputStream)initFile);
            }
        }
        return shell;
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }

    private String join(List<String> s, String delimiter) {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuilder builder = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            builder.append(delimiter);
            builder.append(iter.next());
        }
        return builder.toString();
    }
}

