/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CauseContent
implements EmailContent {
    private static final String TOKEN = "CAUSE";

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Collections.emptyList();
    }

    @Override
    public String getHelpText() {
        return "Displays the cause of the build.\n";
    }

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        List<Object> causes = new LinkedList<Cause>();
        CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
        if (causeAction != null) {
            causes = causeAction.getCauses();
        }
        return this.formatCauses(causes);
    }

    private String formatCauses(List<Cause> causes) {
        if (causes.isEmpty()) {
            return "N/A";
        }
        LinkedList<String> causeNames = new LinkedList<String>();
        for (Cause cause : causes) {
            causeNames.add(cause.getShortDescription());
        }
        return StringUtils.join(causeNames, (String)", ");
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

