/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.AbstractBuild;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovementTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Improvement";
    public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public boolean trigger(AbstractBuild<?, ?> build) {
        if (build.getPreviousBuild() == null) {
            return false;
        }
        if (build.getTestResultAction() == null) {
            return false;
        }
        if (((AbstractBuild)build.getPreviousBuild()).getTestResultAction() == null) {
            return false;
        }
        return build.getTestResultAction().getTotalCount() > 0 && this.getNumFailures(build) < this.getNumFailures((AbstractBuild)build.getPreviousBuild());
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return true;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public String getTriggerName() {
            return ImprovementTrigger.TRIGGER_NAME;
        }

        public EmailTrigger newInstance() {
            return new ImprovementTrigger();
        }

        public String getHelpText() {
            return Messages.ImprovementTrigger_HelpText();
        }
    }
}

