/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Plugin;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.content.BuildLogContent;
import hudson.plugins.emailext.plugins.content.BuildLogRegexContent;
import hudson.plugins.emailext.plugins.content.BuildNumberContent;
import hudson.plugins.emailext.plugins.content.BuildStatusContent;
import hudson.plugins.emailext.plugins.content.BuildURLContent;
import hudson.plugins.emailext.plugins.content.CauseContent;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastBuildContent;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastSuccessfulBuildContent;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastUnstableBuildContent;
import hudson.plugins.emailext.plugins.content.EnvContent;
import hudson.plugins.emailext.plugins.content.FailedTestsContent;
import hudson.plugins.emailext.plugins.content.HudsonURLContent;
import hudson.plugins.emailext.plugins.content.JellyScriptContent;
import hudson.plugins.emailext.plugins.content.JenkinsURLContent;
import hudson.plugins.emailext.plugins.content.ProjectNameContent;
import hudson.plugins.emailext.plugins.content.ProjectURLContent;
import hudson.plugins.emailext.plugins.content.SVNRevisionContent;
import hudson.plugins.emailext.plugins.content.ScriptContent;
import hudson.plugins.emailext.plugins.content.TestCountsContent;
import hudson.plugins.emailext.plugins.content.WorkspaceFileContent;
import hudson.plugins.emailext.plugins.trigger.AbortedTrigger;
import hudson.plugins.emailext.plugins.trigger.FailureTrigger;
import hudson.plugins.emailext.plugins.trigger.FixedTrigger;
import hudson.plugins.emailext.plugins.trigger.NotBuiltTrigger;
import hudson.plugins.emailext.plugins.trigger.PreBuildTrigger;
import hudson.plugins.emailext.plugins.trigger.StillFailingTrigger;
import hudson.plugins.emailext.plugins.trigger.StillUnstableTrigger;
import hudson.plugins.emailext.plugins.trigger.SuccessTrigger;
import hudson.plugins.emailext.plugins.trigger.UnstableTrigger;

public class EmailExtensionPlugin
extends Plugin {
    public void start() throws Exception {
        this.addEmailContentPlugin(new BuildLogContent());
        this.addEmailContentPlugin(new BuildLogRegexContent());
        this.addEmailContentPlugin(new BuildNumberContent());
        this.addEmailContentPlugin(new BuildStatusContent());
        this.addEmailContentPlugin(new BuildURLContent());
        this.addEmailContentPlugin(new ChangesSinceLastBuildContent());
        this.addEmailContentPlugin(new ChangesSinceLastSuccessfulBuildContent());
        this.addEmailContentPlugin(new ChangesSinceLastUnstableBuildContent());
        this.addEmailContentPlugin(new EnvContent());
        this.addEmailContentPlugin(new FailedTestsContent());
        this.addEmailContentPlugin(new JenkinsURLContent());
        this.addEmailContentPlugin(new HudsonURLContent());
        this.addEmailContentPlugin(new ProjectNameContent());
        this.addEmailContentPlugin(new ProjectURLContent());
        this.addEmailContentPlugin(new SVNRevisionContent());
        this.addEmailContentPlugin(new CauseContent());
        this.addEmailContentPlugin(new JellyScriptContent());
        this.addEmailContentPlugin(new WorkspaceFileContent());
        this.addEmailContentPlugin(new TestCountsContent());
        try {
            this.addEmailContentPlugin(new ScriptContent());
        }
        catch (NoClassDefFoundError jvm15Error) {
            System.err.println("ScriptContent not available for JVM 1.5");
        }
        this.addEmailTriggerPlugin(PreBuildTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(FailureTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(StillFailingTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(UnstableTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(StillUnstableTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(SuccessTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(FixedTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(AbortedTrigger.DESCRIPTOR);
        this.addEmailTriggerPlugin(NotBuiltTrigger.DESCRIPTOR);
    }

    private void addEmailContentPlugin(EmailContent content) {
        try {
            ContentBuilder.addEmailContentType(content);
        }
        catch (EmailExtException e) {
            System.err.println(e.getMessage());
        }
    }

    private void addEmailTriggerPlugin(EmailTriggerDescriptor trigger) {
        try {
            ExtendedEmailPublisher.addEmailTriggerType(trigger);
        }
        catch (EmailExtException e) {
            System.err.println(e.getMessage());
        }
    }
}

