/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.recipients.DevelopersRecipientProvider;
import hudson.plugins.emailext.plugins.recipients.ListRecipientProvider;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class RegressionTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Test Regression";

    @DataBoundConstructor
    public RegressionTrigger(List<RecipientProvider> recipientProviders, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(recipientProviders, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Deprecated
    public RegressionTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequester, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(sendToList, sendToDevs, sendToRequester, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        Run<?, ?> previousBuild = ExtendedEmailPublisher.getPreviousRun(build, listener);
        if (previousBuild == null) {
            return build.getResult() == Result.FAILURE;
        }
        if (build.getAction(AbstractTestResultAction.class) == null) {
            return false;
        }
        if (previousBuild.getAction(AbstractTestResultAction.class) == null) {
            return ((AbstractTestResultAction)build.getAction(AbstractTestResultAction.class)).getFailCount() > 0;
        }
        if (((AbstractTestResultAction)build.getAction(AbstractTestResultAction.class)).getFailCount() > ((AbstractTestResultAction)previousBuild.getAction(AbstractTestResultAction.class)).getFailCount()) {
            return true;
        }
        for (Object result : ((AbstractTestResultAction)build.getAction(AbstractTestResultAction.class)).getFailedTests()) {
            CaseResult res = (CaseResult)result;
            if (res.getAge() != 1) continue;
            return true;
        }
        return false;
    }

    @Extension
    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Unstable (Test Failures)");
            this.addTriggerNameToReplace("Unstable (Test Failures) - Still");
            this.addDefaultRecipientProvider(new DevelopersRecipientProvider());
            this.addDefaultRecipientProvider(new ListRecipientProvider());
        }

        @NonNull
        public String getDisplayName() {
            return RegressionTrigger.TRIGGER_NAME;
        }

        @Override
        public EmailTrigger createDefault() {
            return this._createDefault();
        }
    }
}

