/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.text.Template;
import hudson.FilePath;
import hudson.Functions;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.GroovyTemplateConfig;
import hudson.plugins.emailext.groovy.sandbox.EmailExtScriptTokenMacroWhitelist;
import hudson.plugins.emailext.groovy.sandbox.PrintStreamInstanceWhitelist;
import hudson.plugins.emailext.groovy.sandbox.SimpleTemplateEngine;
import hudson.plugins.emailext.groovy.sandbox.StaticProxyInstanceWhitelist;
import hudson.plugins.emailext.groovy.sandbox.TaskListenerInstanceWhitelist;
import hudson.plugins.emailext.plugins.content.AbstractEvalContent;
import hudson.plugins.emailext.plugins.content.EmailExtScript;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import hudson.plugins.emailext.plugins.content.UserProvidedContentInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class ScriptContent
extends AbstractEvalContent {
    private static final Logger LOGGER = Logger.getLogger(ScriptContent.class.getName());
    @DataBoundTokenMacro.Parameter
    public String script = "";
    private static final String DEFAULT_TEMPLATE_NAME = "groovy-html.template";
    @DataBoundTokenMacro.Parameter
    public String template = "groovy-html.template";
    public static final String MACRO_NAME = "SCRIPT";
    private static final Map<String, Reference<Template>> templateCache = new HashMap<String, Reference<Template>>();

    public ScriptContent() {
        super(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        InputStream inputStream = null;
        Object result = "";
        try {
            if (!StringUtils.isEmpty((String)this.script)) {
                inputStream = this.getFileInputStream(run, workspace, this.script, ".groovy");
                result = this.executeScript(run, workspace, listener, inputStream);
            } else {
                inputStream = this.getFileInputStream(run, workspace, this.template, ".template");
                result = this.renderTemplate(run, workspace, listener, inputStream);
            }
        }
        catch (FileNotFoundException e) {
            String missingScriptError = "";
            missingScriptError = !StringUtils.isEmpty((String)this.script) ? this.generateMissingFile("Groovy Script", this.script) : this.generateMissingFile("Groovy Template", this.template);
            LOGGER.log(Level.SEVERE, missingScriptError);
            result = missingScriptError;
        }
        catch (GroovyRuntimeException e) {
            result = "Error in script or template: " + e;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }

    @Override
    protected Class<? extends ConfigProvider> getProviderClass() {
        return GroovyTemplateConfig.GroovyTemplateConfigProvider.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderTemplate(Run<?, ?> build, FilePath workspace, TaskListener listener, InputStream templateStream) {
        Object result;
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        binding.put("build", build);
        binding.put("listener", listener);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("rooturl", descriptor.getHudsonUrl());
        binding.put("project", build.getParent());
        binding.put("workspace", workspace);
        try {
            Template tmpl;
            String text = IOUtils.toString((InputStream)templateStream, (Charset)StandardCharsets.UTF_8);
            boolean approvedScript = false;
            if (templateStream instanceof UserProvidedContentInputStream && !AbstractEvalContent.isApprovedScript(text, GroovyLanguage.get())) {
                approvedScript = false;
                ScriptApproval.get().configuring(text, GroovyLanguage.get(), ApprovalContext.create().withItem((Item)build.getParent()), false);
            } else {
                approvedScript = true;
            }
            GroovyShell shell = this.createEngine(descriptor, Collections.emptyMap(), !approvedScript);
            Object engine = !approvedScript ? new SimpleTemplateEngine(shell, true) : new groovy.text.SimpleTemplateEngine(shell);
            Map<String, Reference<Template>> map = templateCache;
            synchronized (map) {
                String key = text + ":" + approvedScript;
                Reference<Template> templateR = templateCache.get(key);
                Template template = tmpl = templateR == null ? null : templateR.get();
                if (tmpl == null) {
                    tmpl = engine.createTemplate(text);
                    templateCache.put(key, new SoftReference<Template>(tmpl));
                }
            }
            Template tmplR = tmpl;
            if (approvedScript) {
                result = tmplR.make(binding).toString();
            } else {
                StaticProxyInstanceWhitelist whitelist = new StaticProxyInstanceWhitelist(build, "templates-instances.whitelist");
                result = (String)GroovySandbox.runInSandbox(() -> tmplR.make(binding).toString(), (Whitelist)new ProxyWhitelist(new Whitelist[]{Whitelist.all(), new TaskListenerInstanceWhitelist(listener), new PrintStreamInstanceWhitelist(listener.getLogger()), new EmailExtScriptTokenMacroWhitelist(), whitelist}));
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Functions.printStackTrace((Throwable)e, (PrintWriter)pw);
            result = "Exception raised during template rendering: " + e.getMessage() + "\n\n" + sw;
        }
        return result;
    }

    private String executeScript(Run<?, ?> build, FilePath workspace, TaskListener listener, InputStream scriptStream) throws IOException {
        String result = "";
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        Job parent = build.getParent();
        binding.put("build", build);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("project", parent);
        binding.put("rooturl", descriptor.getHudsonUrl());
        binding.put("workspace", workspace);
        PrintStream logger = listener.getLogger();
        binding.put("logger", logger);
        String scriptContent = IOUtils.toString((InputStream)scriptStream, (String)descriptor.getCharset());
        if (scriptStream instanceof UserProvidedContentInputStream) {
            ScriptApproval.get().configuring(scriptContent, GroovyLanguage.get(), ApprovalContext.create().withItem((Item)parent));
        }
        if (scriptStream instanceof UserProvidedContentInputStream && !AbstractEvalContent.isApprovedScript(scriptContent, GroovyLanguage.get())) {
            GroovyShell shell = this.createEngine(descriptor, binding, true);
            Object res = GroovySandbox.run((GroovyShell)shell, (String)scriptContent, (Whitelist)new ProxyWhitelist(new Whitelist[]{Whitelist.all(), new PrintStreamInstanceWhitelist(logger), new EmailExtScriptTokenMacroWhitelist()}));
            if (res != null) {
                result = res.toString();
            }
        } else {
            GroovyShell shell;
            Script script;
            Object res;
            if (scriptStream instanceof UserProvidedContentInputStream) {
                ScriptApproval.get().using(scriptContent, GroovyLanguage.get());
            }
            if ((res = (script = (shell = this.createEngine(descriptor, binding, false)).parse(scriptContent)).run()) != null) {
                result = res.toString();
            }
        }
        return result;
    }

    private GroovyShell createEngine(ExtendedEmailPublisherDescriptor descriptor, Map<String, Object> variables, boolean secure) {
        CompilerConfiguration cc;
        ClassLoader cl;
        if (secure) {
            cl = GroovySandbox.createSecureClassLoader((ClassLoader)Jenkins.get().getPluginManager().uberClassLoader);
            cc = GroovySandbox.createSecureCompilerConfiguration();
        } else {
            cl = Jenkins.get().getPluginManager().uberClassLoader;
            cc = new CompilerConfiguration();
        }
        cc.setScriptBaseClass(EmailExtScript.class.getCanonicalName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        Binding binding = new Binding();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            binding.setVariable(e.getKey(), e.getValue());
        }
        return new GroovyShell(cl, binding, cc);
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

