/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class MailAccount
extends AbstractDescribableImpl<MailAccount> {
    private String address;
    private String smtpHost;
    private String smtpPort = "25";
    private transient String smtpUsername;
    private transient Secret smtpPassword;
    private String credentialsId;
    private boolean useSsl;
    private boolean useTls;
    private String advProperties;
    private boolean defaultAccount;
    private boolean useOAuth2;

    @Deprecated
    public MailAccount(JSONObject jo) {
        this.address = Util.nullify((String)jo.optString("address", null));
        this.smtpHost = Util.nullify((String)jo.optString("smtpHost", null));
        this.smtpPort = Util.nullify((String)jo.optString("smtpPort", null));
        if (jo.optBoolean("auth", false)) {
            this.credentialsId = Util.nullify((String)jo.optString("credentialsId", null));
        }
        this.useSsl = jo.optBoolean("useSsl", false);
        this.useTls = jo.optBoolean("useTls", false);
        this.advProperties = Util.nullify((String)jo.optString("advProperties", null));
    }

    @DataBoundConstructor
    public MailAccount() {
    }

    public boolean isValid() {
        return this.isFromAddressValid() && this.isSmtpServerValid();
    }

    public boolean isFromAddressValid() {
        return this.isDefaultAccount() || StringUtils.isNotBlank((String)this.address);
    }

    public boolean isSmtpServerValid() {
        return true;
    }

    public boolean isSmtpAuthValid() {
        return true;
    }

    public boolean isDefaultAccount() {
        return this.defaultAccount;
    }

    @DataBoundSetter
    void setDefaultAccount(boolean defaultAccount) {
        this.defaultAccount = defaultAccount;
    }

    public MailAccountDescriptor getDescriptor() {
        return (MailAccountDescriptor)Jenkins.get().getDescriptor(((Object)((Object)this)).getClass());
    }

    public String getAddress() {
        return this.address;
    }

    @DataBoundSetter
    public void setAddress(String address) {
        this.address = Util.fixEmptyAndTrim((String)address);
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    @DataBoundSetter
    public void setSmtpHost(String smtpHost) {
        this.smtpHost = Util.fixEmptyAndTrim((String)smtpHost);
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    @DataBoundSetter
    public void setSmtpPort(String smtpPort) {
        this.smtpPort = Util.fixEmptyAndTrim((String)smtpPort);
    }

    @Deprecated
    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    @DataBoundSetter
    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = Util.fixEmptyAndTrim((String)smtpUsername);
    }

    @Deprecated
    public Secret getSmtpPassword() {
        return this.smtpPassword;
    }

    @DataBoundSetter
    public void setSmtpPassword(Secret smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = Secret.fromString((String)smtpPassword);
    }

    public String getCredentialsId() {
        if (StringUtils.isBlank((String)this.credentialsId) && StringUtils.isNotBlank((String)this.smtpUsername) && this.smtpPassword != null) {
            this.migrateCredentials();
        }
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    @DataBoundSetter
    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    @DataBoundSetter
    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public boolean isUseOAuth2() {
        return this.useOAuth2;
    }

    @DataBoundSetter
    public void setUseOAuth2(boolean useOAuth2) {
        this.useOAuth2 = useOAuth2;
    }

    public String getAdvProperties() {
        return this.advProperties;
    }

    @DataBoundSetter
    public void setAdvProperties(String advProperties) {
        this.advProperties = advProperties;
    }

    private Object readResolve() {
        if (StringUtils.isBlank((String)this.credentialsId) && StringUtils.isNotBlank((String)this.smtpUsername) && this.smtpPassword != null) {
            this.migrateCredentials();
        }
        return this;
    }

    private void migrateCredentials() {
        HostnamePortRequirement domainRequirement = null;
        if (StringUtils.isNotBlank((String)this.smtpHost) && StringUtils.isNotBlank((String)this.smtpPort)) {
            domainRequirement = new HostnamePortRequirement(this.smtpHost, Integer.parseInt(this.smtpPort));
        }
        List credentials = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{domainRequirement}), (CredentialsMatcher)CredentialsMatchers.withUsername((String)this.smtpUsername));
        for (StandardUsernamePasswordCredentials cred : credentials) {
            if (!StringUtils.equals((String)this.smtpPassword.getPlainText(), (String)Secret.toString((Secret)cred.getPassword()))) continue;
            this.credentialsId = cred.getId();
            break;
        }
        if (StringUtils.isBlank((String)this.credentialsId)) {
            UsernamePasswordCredentialsImpl newCredentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, "Migrated from email-ext username/password", this.smtpUsername, this.smtpPassword.getPlainText());
            SystemCredentialsProvider.getInstance().getCredentials().add(newCredentials);
            this.credentialsId = newCredentials.getId();
        }
        this.smtpUsername = null;
        this.smtpPassword = null;
    }

    @Extension
    public static class MailAccountDescriptor
    extends Descriptor<MailAccount> {
        @NonNull
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            if (CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), null, (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }
    }
}

