/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.recipients.DevelopersRecipientProvider;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class StillFailingTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Failure - Still";

    @DataBoundConstructor
    public StillFailingTrigger(List<RecipientProvider> recipientProviders, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(recipientProviders, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Deprecated
    public StillFailingTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequester, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(sendToList, sendToDevs, sendToRequester, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        Run<?, ?> prevRun;
        Result buildResult = build.getResult();
        return buildResult == Result.FAILURE && (prevRun = ExtendedEmailPublisher.getPreviousRun(build, listener)) != null && prevRun.getResult() == Result.FAILURE;
    }

    @Extension
    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Failure - Any");
            this.addDefaultRecipientProvider(new DevelopersRecipientProvider());
        }

        @NonNull
        public String getDisplayName() {
            return StillFailingTrigger.TRIGGER_NAME;
        }

        @Override
        public EmailTrigger createDefault() {
            return this._createDefault();
        }
    }
}

