/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import hudson.scm.ChangeLogSet;
import jakarta.mail.internet.InternetAddress;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpstreamComitterRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public UpstreamComitterRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        debug.send("Sending email to upstream committer(s).", new Object[0]);
        for (Run<?, ?> run : new HashSet(UpstreamComitterRecipientProvider.getUpstreamBuilds(context.getRun()))) {
            this.addUpstreamCommittersTriggeringBuild(run, to, cc, bcc, env, context, debug);
        }
    }

    private static List<Run<?, ?>> getUpstreamBuilds(Run<?, ?> build) {
        ArrayList upstreams = new ArrayList();
        for (Cause c : build.getCauses()) {
            if (!(c instanceof Cause.UpstreamCause)) continue;
            upstreams.addAll(UpstreamComitterRecipientProvider.upstreamCauseToRuns((Cause.UpstreamCause)c));
        }
        return upstreams;
    }

    private static List<Run<?, ?>> upstreamCauseToRuns(Cause.UpstreamCause cause) {
        ArrayList upstreams = new ArrayList();
        Run r = cause.getUpstreamRun();
        if (r != null) {
            upstreams.add(r);
            for (Cause c : cause.getUpstreamCauses()) {
                if (!(c instanceof Cause.UpstreamCause)) continue;
                upstreams.addAll(UpstreamComitterRecipientProvider.upstreamCauseToRuns((Cause.UpstreamCause)c));
            }
        }
        return upstreams;
    }

    private void addUpstreamCommittersTriggeringBuild(Run<?, ?> run, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, ExtendedEmailPublisherContext context, RecipientProviderUtilities.IDebug debug) {
        debug.send("Adding upstream committer from job %s with build number %s", run.getParent().getDisplayName(), run.getNumber());
        if (run instanceof RunWithSCM) {
            List changeSets = ((RunWithSCM)run).getChangeSets();
            for (ChangeLogSet changeSet : changeSets) {
                for (ChangeLogSet.Entry change : changeSet) {
                    this.addUserFromChangeSet(change, to, cc, bcc, env, context, debug);
                }
            }
        }
    }

    private void addUserFromChangeSet(ChangeLogSet.Entry change, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, ExtendedEmailPublisherContext context, RecipientProviderUtilities.IDebug debug) {
        User user = change.getAuthor();
        RecipientProviderUtilities.addUsers(Collections.singleton(user), context, env, to, cc, bcc, debug);
    }

    @Extension
    @Symbol(value={"upstreamDevelopers"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.UpstreamComitterRecipientProvider_DisplayName();
        }
    }
}

