/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.ui;

import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;

public class SelectFieldUtils {
    public static ListBoxModel getListBoxModelOnException(String displayValue) {
        SelectItemValidationWrapper selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching values for this parameter. Check the Jenkins logs for more details.", "");
        ListBoxModel m = new ListBoxModel();
        m.add((Object)new ListBoxModel.Option(displayValue, selectItemValidationWrapper.getJsonStr(), true));
        return m;
    }

    public static ListBoxModel getListBoxModelOnWrongConf(String displayValue) {
        SelectItemValidationWrapper selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Connection to Electric Flow Server Failed. Please fix connection information and reload this page.", "");
        ListBoxModel m = new ListBoxModel();
        m.add((Object)new ListBoxModel.Option(displayValue, selectItemValidationWrapper.getJsonStr(), true));
        return m;
    }

    public static FormValidation getFormValidationBasedOnSelectItemValidationWrapper(String item) {
        if (SelectFieldUtils.isSelectItemValidationWrapper(item)) {
            SelectItemValidationWrapper selectItemValidationWrapper = new SelectItemValidationWrapper(item);
            switch (selectItemValidationWrapper.getValidationStatus()) {
                case ERROR: {
                    return FormValidation.error((String)selectItemValidationWrapper.getValidationMessage());
                }
                case WARN: {
                    return FormValidation.warning((String)selectItemValidationWrapper.getValidationMessage());
                }
                case OK: {
                    return FormValidation.ok((String)selectItemValidationWrapper.getValidationMessage());
                }
            }
        }
        return null;
    }

    public static boolean isSelectItemValidationWrapper(String item) {
        return item != null && !item.isEmpty() && item.startsWith("{") && item.contains("validationStatus") && item.contains("validationMessage") && item.contains("value") && item.endsWith("}");
    }

    public static String getSelectItemValue(String item) {
        return SelectFieldUtils.isSelectItemValidationWrapper(item) ? new SelectItemValidationWrapper(item).getValue() : item;
    }

    public static boolean checkAllSelectItemsAreNotValidationWrappers(String ... items) {
        for (String item : items) {
            if (!SelectFieldUtils.isSelectItemValidationWrapper(item)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAnySelectItemsIsValidationWrappers(String ... items) {
        return Arrays.stream(items).anyMatch(SelectFieldUtils::isSelectItemValidationWrapper);
    }
}

