/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.RelaxedSSLContext;

public class MultipartUtility {
    private static final String LINE_FEED = "\r\n";
    private static final Log log = LogFactory.getLog(MultipartUtility.class);
    private final String boundary;
    private HttpsURLConnection httpConn;
    private final String charset;
    private OutputStream outputStream;
    private PrintWriter writer;

    public MultipartUtility(String requestURL, String charset, boolean ignoreSslConnectionErrors) throws IOException {
        this.charset = charset;
        this.boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(requestURL);
        this.httpConn = (HttpsURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        if (ignoreSslConnectionErrors) {
            block3: {
                try {
                    this.httpConn.setSSLSocketFactory(RelaxedSSLContext.getInstance().getSocketFactory());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.httpConn.setHostnameVerifier(RelaxedSSLContext.allHostsValid);
        }
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFilePart(String fieldName, File uploadFile, String workspaceDir) throws IOException {
        String absolutePath = uploadFile.getAbsolutePath();
        String fileName = absolutePath.substring(workspaceDir.length(), absolutePath.length());
        fileName = fileName.replaceAll("\\\\", "/");
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(fieldName).append("\"; filename=\"").append(fileName).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        try (FileInputStream inputStream = new FileInputStream(uploadFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
            }
            this.outputStream.flush();
            inputStream.close();
            this.writer.append(LINE_FEED);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public void addFormField(String name, String value) {
        this.writer.append("--").append(this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=").append(this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String name, String value) {
        this.writer.append(name).append(": ").append(value).append(LINE_FEED);
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> finish() throws IOException {
        ArrayList<String> response;
        block6: {
            response = new ArrayList<String>();
            this.writer.append(LINE_FEED).flush();
            this.writer.append("--").append(this.boundary).append("--").append(LINE_FEED);
            this.writer.close();
            try {
                int status = this.httpConn.getResponseCode();
                if (status == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream(), "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        response.add(line);
                    }
                    reader.close();
                    this.httpConn.disconnect();
                    break block6;
                }
                throw new IOException("Server returned non-OK status: " + status);
            }
            finally {
                this.writer.close();
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
        }
        return response;
    }
}

