/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.SummaryTextAction;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.ui.FieldValidationStatus;
import org.jenkinsci.plugins.electricflow.ui.HtmlUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectFieldUtils;
import org.jenkinsci.plugins.electricflow.ui.SelectItemValidationWrapper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ElectricFlowRunProcedure
extends Recorder
implements SimpleBuildStep {
    private static final Log log = LogFactory.getLog(ElectricFlowRunProcedure.class);
    private String configuration;
    private String projectName;
    private String procedureName;
    private String procedureParameters;

    @DataBoundConstructor
    public ElectricFlowRunProcedure() {
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        boolean isSuccess = this.runProcedure(run, taskListener);
        if (!isSuccess) {
            run.setResult(Result.FAILURE);
        }
    }

    private boolean runProcedure(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener) {
        ElectricFlowClient efClient = new ElectricFlowClient(this.configuration);
        PrintStream logger = taskListener.getLogger();
        logger.println("Project name: " + this.projectName + ", Procedure name: " + this.procedureName);
        JSONObject procedure = JSONObject.fromObject((Object)this.procedureParameters).getJSONObject("procedure");
        JSONArray parameter = JSONArray.fromObject((Object)procedure.getString("parameters"));
        try {
            logger.println("Preparing to run procedure...");
            String result = efClient.runProcedure(this.projectName, this.procedureName, parameter);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("procedureName", this.procedureName);
            args.put("result", result);
            String summaryHtml = this.getSummaryHtml(efClient, parameter, args);
            SummaryTextAction action = new SummaryTextAction(run, summaryHtml);
            run.addAction((Action)action);
            run.save();
            logger.println("Run procedure result: " + Utils.formatJsonOutput(result));
        }
        catch (Exception e) {
            logger.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getStoredConfiguration() {
        return this.configuration;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getStoredProjectName() {
        return this.projectName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getStoredProcedureName() {
        return this.procedureName;
    }

    public String getProcedureParameters() {
        return this.procedureParameters;
    }

    public String getStoredProcedureParameters() {
        return this.procedureParameters;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String getSummaryHtml(ElectricFlowClient configuration, JSONArray parameters, Map<String, String> args) {
        String result = args.get("result");
        String procedureName = args.get("procedureName");
        String jobId = JSONObject.fromObject((Object)result).getString("jobId");
        String jobUrl = configuration.getElectricFlowUrl() + "/commander/link/jobDetails/jobs/" + jobId;
        String summaryText = "<h3>ElectricFlow Run Procedure</h3><table cellspacing=\"2\" cellpadding=\"4\"> \n  <tr>\n    <td>Procedure Name:</td>\n    <td><a href='" + HtmlUtils.encodeForHtml(jobUrl) + "'>" + HtmlUtils.encodeForHtml(procedureName) + "</a></td>   \n  </tr>";
        summaryText = Utils.getParametersHTML(parameters, summaryText, "actualParameterName", "value");
        summaryText = summaryText + "</table>";
        return summaryText;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @DataBoundSetter
    public void setProjectName(String projectName) {
        this.projectName = SelectFieldUtils.getSelectItemValue(projectName);
    }

    @DataBoundSetter
    public void setProcedureName(String procedureName) {
        this.procedureName = SelectFieldUtils.getSelectItemValue(procedureName);
    }

    @DataBoundSetter
    public void setProcedureParameters(String procedureParameters) {
        this.procedureParameters = SelectFieldUtils.getSelectItemValue(procedureParameters);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckConfiguration(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return Utils.validateConfiguration(value);
        }

        public FormValidation doCheckProjectName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Project name");
        }

        public FormValidation doCheckProcedureName(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return Utils.validateValueOnEmpty(value, "Procedure name");
        }

        public FormValidation doCheckProcedureParameters(@QueryParameter String value, @QueryParameter boolean validationTrigger, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (SelectFieldUtils.isSelectItemValidationWrapper(value)) {
                return SelectFieldUtils.getFormValidationBasedOnSelectItemValidationWrapper(value);
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillConfigurationItems(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.fillConfigurationItems();
        }

        public ListBoxModel doFillProjectNameItems(@QueryParameter String configuration, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return Utils.getProjects(configuration);
        }

        public ListBoxModel doFillProcedureNameItems(@QueryParameter String projectName, @QueryParameter String configuration, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                ListBoxModel m = new ListBoxModel();
                m.add("Select procedure", "");
                if (!configuration.isEmpty() && !projectName.isEmpty() && SelectFieldUtils.checkAllSelectItemsAreNotValidationWrappers(projectName)) {
                    ElectricFlowClient client = new ElectricFlowClient(configuration);
                    List<String> procedures = client.getProcedures(projectName);
                    for (String procedure : procedures) {
                        m.add(procedure);
                    }
                }
                return m;
            }
            catch (Exception e) {
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching values for this parameter - procedure. Error message: " + e.getMessage()), (Throwable)e);
                    return SelectFieldUtils.getListBoxModelOnException("Select procedure");
                }
                return SelectFieldUtils.getListBoxModelOnWrongConf("Select procedure");
            }
        }

        public ListBoxModel doFillProcedureParametersItems(@QueryParameter String configuration, @QueryParameter String projectName, @QueryParameter String procedureName, @QueryParameter String procedureParameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            try {
                JSONObject json;
                JSONObject jsonArray;
                ListBoxModel m = new ListBoxModel();
                if (configuration.isEmpty() || projectName.isEmpty() || procedureName.isEmpty() || SelectFieldUtils.checkAnySelectItemsIsValidationWrappers(projectName, procedureName)) {
                    m.add("{}");
                    return m;
                }
                ElectricFlowClient client = new ElectricFlowClient(configuration);
                HashMap<String, String> storedParams = new HashMap();
                String deployParametersValue = SelectFieldUtils.getSelectItemValue(procedureParameters);
                if (!deployParametersValue.isEmpty() && !"{}".equals(deployParametersValue) && procedureName.equals((jsonArray = (json = JSONObject.fromObject((Object)deployParametersValue)).getJSONObject("procedure")).get("procedureName"))) {
                    storedParams = DescriptorImpl.getParamsMapFromProcedureParams(deployParametersValue);
                }
                List<String> parameters = client.getProcedureFormalParameters(projectName, procedureName);
                JSONObject main = JSONObject.fromObject((Object)("{'procedure':{'procedureName':'" + procedureName + "',   'parameters':[]}}"));
                JSONArray ja = main.getJSONObject("procedure").getJSONArray("parameters");
                Utils.addParametersToJsonAndPreserveStored(parameters, ja, "actualParameterName", "value", storedParams);
                m.add(main.toString());
                if (m.isEmpty()) {
                    m.add("{}");
                }
                return m;
            }
            catch (Exception e) {
                SelectItemValidationWrapper selectItemValidationWrapper;
                ListBoxModel m = new ListBoxModel();
                if (Utils.isEflowAvailable(configuration)) {
                    log.error((Object)("Error when fetching set of procedure parameters. Error message: " + e.getMessage()), (Throwable)e);
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of procedure parameters. Check the Jenkins logs for more details.", "{}");
                } else {
                    selectItemValidationWrapper = new SelectItemValidationWrapper(FieldValidationStatus.ERROR, "Error when fetching set of procedure parameters. Connection to Electric Flow Server Failed. Please fix connection information and reload this page.", "{}");
                }
                m.add(selectItemValidationWrapper.getJsonStr());
                return m;
            }
        }

        public String getDisplayName() {
            return "ElectricFlow - Run Procedure";
        }

        public String getId() {
            return "electricFlowRunProcedure";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doShowOldValues(@QueryParameter(value="configuration") String configuration, @QueryParameter(value="projectName") String projectName, @QueryParameter(value="procedureName") String procedureName, @QueryParameter(value="procedureParameters") String procedureParameters, @QueryParameter(value="storedConfiguration") String storedConfiguration, @QueryParameter(value="storedProjectName") String storedProjectName, @QueryParameter(value="storedProcedureName") String storedProcedureName, @QueryParameter(value="storedProcedureParameters") String storedProcedureParameters, @AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            String configurationValue = configuration;
            String projectNameValue = SelectFieldUtils.getSelectItemValue(projectName);
            String procedureNameValue = SelectFieldUtils.getSelectItemValue(procedureName);
            String procedureParametersValue = SelectFieldUtils.getSelectItemValue(procedureParameters);
            Map<String, String> procedureParamsMap = DescriptorImpl.getParamsMapFromProcedureParams(procedureParametersValue);
            Map<String, String> storedProcedureParamsMap = DescriptorImpl.getParamsMapFromProcedureParams(storedProcedureParameters);
            String comparisonTable = "<table>" + Utils.getValidationComparisonHeaderRow() + Utils.getValidationComparisonRow("Configuration", storedConfiguration, configurationValue) + Utils.getValidationComparisonRow("Project Name", storedProjectName, projectNameValue) + Utils.getValidationComparisonRow("Procedure Name", storedProcedureName, procedureNameValue) + Utils.getValidationComparisonRowsForExtraParameters("Procedure Parameters", storedProcedureParamsMap, procedureParamsMap) + "</table>";
            if (configurationValue.equals(storedConfiguration) && projectNameValue.equals(storedProjectName) && procedureNameValue.equals(storedProcedureName) && procedureParamsMap.equals(storedProcedureParamsMap)) {
                return FormValidation.okWithMarkup((String)("No changes detected:<br>" + comparisonTable));
            }
            return FormValidation.warningWithMarkup((String)("Changes detected:<br>" + comparisonTable));
        }

        static Map<String, String> getParamsMapFromProcedureParams(String procedureParameters) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            if (procedureParameters == null || procedureParameters.isEmpty() || procedureParameters.equals("{}")) {
                return paramsMap;
            }
            JSONObject json = JSONObject.fromObject((Object)procedureParameters);
            if (!json.containsKey((Object)"procedure") || !json.getJSONObject("procedure").containsKey((Object)"parameters")) {
                return paramsMap;
            }
            return Utils.getParamsMap(JSONArray.fromObject((Object)json.getJSONObject("procedure").getString("parameters")), "actualParameterName", "value");
        }
    }
}

